/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.link;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.wcm.handler.link.Link;
import io.wcm.wcm.core.components.impl.link.LinkHtmlAttributesSerializer;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinkWrapper
implements com.adobe.cq.wcm.core.components.commons.link.Link {
    private final Link link;

    public LinkWrapper(@NotNull Link link) {
        this.link = link;
    }

    public boolean isValid() {
        return this.link.isValid();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="url")
    @Nullable
    public String getURL() {
        return this.link.getUrl();
    }

    @JsonIgnore
    @Nullable
    public String getMappedURL() {
        return this.link.getUrl();
    }

    @JsonIgnore
    @Nullable
    public String getExternalizedURL() {
        return this.link.getUrl();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=LinkHtmlAttributesSerializer.class)
    @JsonProperty(value="attributes")
    @NotNull
    public Map getHtmlAttributes() {
        return this.link.getAnchorAttributes();
    }

    @JsonIgnore
    @Nullable
    public Object getReference() {
        return ObjectUtils.firstNonNull((Object[])new Adaptable[]{this.link.getTargetPage(), this.link.getTargetAsset()});
    }

    @JsonIgnore
    @Nullable
    public com.adobe.cq.wcm.core.components.commons.link.Link orNull() {
        if (this.link.isValid()) {
            return this;
        }
        return null;
    }

    @JsonIgnore
    @NotNull
    public Link getLinkObject() {
        return this.link;
    }
}

