/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.helpers;

import com.adobe.cq.wcm.core.components.models.LanguageNavigationItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import io.wcm.handler.link.Link;
import io.wcm.wcm.core.components.impl.models.helpers.NavigationItemV2Impl;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageNavigationItemV2Impl
extends NavigationItemV2Impl
implements LanguageNavigationItem {
    private final Page page;
    private final String title;
    private Locale locale;
    private String country;
    private String language;

    public LanguageNavigationItemV2Impl(@NotNull Page page, @NotNull Link link, int level, boolean active, boolean current, @NotNull List<NavigationItem> children, @Nullable String title, @Nullable String parentId, @Nullable Component parentComponent) {
        super(page, link, level, active, current, children, parentId, parentComponent);
        this.page = page;
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.page.getLanguage(false);
        }
        return this.locale;
    }

    public String getCountry() {
        if (this.country == null) {
            this.country = this.page.getLanguage(false).getCountry();
        }
        return this.country;
    }

    public String getLanguage() {
        if (this.language == null) {
            this.language = this.page.getLanguage(false).toString().replace('_', '-');
        }
        return this.language;
    }

    @Override
    @NotNull
    protected final PageData getComponentData() {
        return DataLayerBuilder.extending((ComponentData)super.getComponentData()).asPage().withLanguage(this::getLanguage).build();
    }
}

