/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Download;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.designer.Style;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.Rendition;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.models.mixin.MediaMixin;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Download.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/download/v1/download", "wcm-io/wcm/core/components/download/v2/download"})
@Exporter(name="jackson", extensions={"json"})
public class DownloadV1V2Impl
extends AbstractComponentImpl
implements Download,
MediaMixin {
    static final String RESOURCE_TYPE_V1 = "wcm-io/wcm/core/components/download/v1/download";
    static final String RESOURCE_TYPE_V2 = "wcm-io/wcm/core/components/download/v2/download";
    @AemObject
    private Style currentStyle;
    @ValueMapValue(name="jcr:title", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String title;
    @ValueMapValue(name="jcr:description", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String description;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String actionText;
    @Self
    private MediaHandler mediaHandler;
    private boolean titleFromAsset;
    private boolean descriptionFromAsset;
    private boolean inline;
    private boolean displaySize;
    private boolean displayFormat;
    private boolean displayFilename;
    private boolean hideTitleLink;
    private String titleType;
    private String filename;
    private String format;
    private String size;
    private String extension;
    private Media media;

    @PostConstruct
    protected void initModel() {
        ValueMap properties = this.resource.getValueMap();
        this.titleFromAsset = (Boolean)properties.get("titleFromAsset", (Object)this.titleFromAsset);
        this.descriptionFromAsset = (Boolean)properties.get("descriptionFromAsset", (Object)this.descriptionFromAsset);
        this.inline = (Boolean)properties.get("inline", (Object)this.inline);
        if (this.currentStyle != null) {
            this.titleType = (String)this.currentStyle.get("titleType", String.class);
            this.displaySize = (Boolean)this.currentStyle.get("displaySize", (Object)true);
            this.displayFormat = (Boolean)this.currentStyle.get("displayFormat", (Object)true);
            this.displayFilename = (Boolean)this.currentStyle.get("displayFilename", (Object)true);
            this.hideTitleLink = (Boolean)this.currentStyle.get("hideTitleLink", (Object)false);
        }
        this.media = this.mediaHandler.get(this.resource, new MediaArgs().download(true).contentDispositionAttachment(!this.inline)).build();
        if (this.media.isValid()) {
            this.initPropertiesFromMedia();
        }
    }

    private void initPropertiesFromMedia() {
        Asset damAsset;
        io.wcm.handler.media.Asset asset;
        Rendition rendition = this.media.getRendition();
        if (rendition != null) {
            this.filename = rendition.getFileName();
            this.format = rendition.getMimeType();
            this.size = FileUtils.byteCountToDisplaySize((long)rendition.getFileSize());
            this.extension = rendition.getFileExtension();
        }
        if ((asset = this.media.getAsset()) != null && (damAsset = (Asset)asset.adaptTo(Asset.class)) != null) {
            String assetDescription;
            if (this.titleFromAsset) {
                this.title = damAsset.getMetadataValueFromJcr("dc:title");
            }
            if (this.descriptionFromAsset && StringUtils.isNotEmpty((CharSequence)(assetDescription = damAsset.getMetadataValueFromJcr("dc:description")))) {
                this.description = assetDescription;
            }
        }
    }

    @Override
    @NotNull
    public Media getMediaObject() {
        return this.media;
    }

    public String getUrl() {
        return this.media.getUrl();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getActionText() {
        return this.actionText;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFormat() {
        return this.format;
    }

    public String getSize() {
        return this.size;
    }

    public boolean displaySize() {
        return this.displaySize;
    }

    public boolean displayFormat() {
        return this.displayFormat;
    }

    public boolean displayFilename() {
        return this.displayFilename;
    }

    public boolean hideTitleLink() {
        return this.hideTitleLink;
    }

    public String getExtension() {
        return this.extension;
    }
}

