/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.AssetDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ImageComponentDataBuilder;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.ImageAreaV1Impl;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import io.wcm.wcm.core.components.models.mixin.LinkMixin;
import io.wcm.wcm.core.components.models.mixin.MediaMixin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/image/v2/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageV2Impl
extends AbstractComponentImpl
implements Image,
MediaMixin,
LinkMixin {
    public static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/image/v2/image";
    private static final String WIDTH_PLACEHOLDER = "{.width}";
    @AemObject
    private Style currentStyle;
    @Self
    private LinkHandler linkHandler;
    @Self
    private MediaHandler mediaHandler;
    @Self
    private UrlHandler urlHandler;
    @ValueMapValue(name="alt", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String alt;
    @ValueMapValue(name="jcr:title", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String imageCrop;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String imageRotate;
    private Link link;
    private Media media;
    private String uuid;
    private String fileReference;
    private boolean displayPopupTitle;
    private boolean enableLazyLoading;
    private int lazyThreshold;
    private boolean isDecorative;
    private List<ImageArea> areas;
    private List<Long> widths = Collections.emptyList();
    private long noScriptWidth;
    private String srcPattern;

    @PostConstruct
    private void activate() {
        ValueMap properties = this.resource.getValueMap();
        this.displayPopupTitle = (Boolean)properties.get("displayPopupTitle", (Object)((Boolean)this.currentStyle.get("displayPopupTitle", (Object)true)));
        this.enableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)true) == false;
        this.lazyThreshold = (Integer)this.currentStyle.get("lazyThreshold", (Object)0);
        this.isDecorative = (Boolean)properties.get("isDecorative", (Object)((Boolean)this.currentStyle.get("isDecorative", (Object)false)));
        boolean altFromAsset = (Boolean)properties.get("altValueFromDAM", (Object)((Boolean)this.currentStyle.get("altValueFromDAM", (Object)true)));
        this.media = HandlerUnwrapper.get(this.mediaHandler, this.resource).dynamicMediaDisabled(true).decorative(this.isDecorative).forceAltValueFromAsset(altFromAsset).build();
        if (this.media.isValid() && !this.media.getRendition().isImage()) {
            this.media = this.mediaHandler.invalid();
        }
        if (this.media.isValid()) {
            this.initPropertiesFromDamAsset(properties);
            this.widths = this.buildRenditionWidths(this.media.getRendition());
            this.noScriptWidth = this.getNoScriptWidth();
            this.srcPattern = this.buildSrcPattern(this.media.getUrl());
            this.areas = ImageAreaV1Impl.convertMap(this.media.getMap());
        }
        this.link = this.isDecorative ? this.linkHandler.invalid() : HandlerUnwrapper.get(this.linkHandler, this.resource).build();
    }

    private void initPropertiesFromDamAsset(ValueMap properties) {
        Asset damAsset;
        io.wcm.handler.media.Asset asset = this.media.getAsset();
        if (asset != null && (damAsset = (Asset)asset.adaptTo(Asset.class)) != null) {
            String assetTitle;
            boolean titleFromAsset = (Boolean)properties.get("titleValueFromDAM", (Object)((Boolean)this.currentStyle.get("titleValueFromDAM", (Object)true)));
            boolean uuidDisabled = (Boolean)this.currentStyle.get("uuidDisabled", (Object)false);
            this.fileReference = damAsset.getPath();
            this.alt = asset.getAltText();
            if (!uuidDisabled) {
                this.uuid = damAsset.getID();
            }
            if (titleFromAsset && StringUtils.isNotEmpty((CharSequence)(assetTitle = asset.getTitle()))) {
                this.title = assetTitle;
            }
        }
    }

    @Override
    @NotNull
    public Link getLinkObject() {
        return this.link;
    }

    @Override
    @NotNull
    public Media getMediaObject() {
        return this.media;
    }

    public String getSrc() {
        if (this.noScriptWidth > 0L) {
            return StringUtils.replace((String)this.srcPattern, (String)WIDTH_PLACEHOLDER, (String)("." + this.noScriptWidth));
        }
        return this.media.getUrl();
    }

    public String getAlt() {
        return this.alt;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public String getLink() {
        return this.link.getUrl();
    }

    public boolean displayPopupTitle() {
        return this.displayPopupTitle;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public boolean isLazyEnabled() {
        return this.enableLazyLoading;
    }

    public int getLazyThreshold() {
        return this.lazyThreshold;
    }

    public String getSrcUriTemplate() {
        return this.srcPattern;
    }

    public int @NotNull [] getWidths() {
        return this.widths.stream().mapToInt(Long::intValue).toArray();
    }

    public List<ImageArea> getAreas() {
        return this.areas;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Deprecated
    public String getJson() {
        return null;
    }

    private List<Long> buildRenditionWidths(Rendition rendition) {
        long maxWidth = rendition.getWidth();
        String[] configuredWidths = (String[])this.currentStyle.get("allowedRenditionWidths", (Object)new String[0]);
        return Arrays.stream(configuredWidths).map(NumberUtils::toLong).filter(width -> width > 0L && width <= maxWidth).sorted().collect(Collectors.toList());
    }

    private long getNoScriptWidth() {
        if (this.widths.isEmpty()) {
            return 0L;
        }
        return this.widths.get((int)Math.round((double)this.widths.size() / 2.0 - 0.5));
    }

    private String buildSrcPattern(String mediaUrl) {
        String extension = StringUtils.substringAfterLast((String)mediaUrl, (String)".");
        String fileName = StringUtils.substringAfterLast((String)mediaUrl, (String)"/");
        StringBuilder suffix = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.imageCrop)) {
            suffix.append(this.imageCrop).append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.imageRotate)) {
            suffix.append(this.imageRotate).append("/");
        }
        suffix.append(fileName);
        String url = this.urlHandler.get(this.resource).selectors("imgwidth").extension(extension).suffix(suffix.toString()).buildExternalResourceUrl();
        return StringUtils.replace((String)url, (String)".imgwidth.", (String)".imgwidth{.width}.");
    }

    @JsonIgnore
    @NotNull
    public ImageData getComponentData() {
        return ((ImageComponentDataBuilder)((ImageComponentDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asImageComponent().withTitle(this::getTitle)).withLinkUrl(this::getLink)).withAssetData(() -> Optional.of(this.media).filter(Media::isValid).map(Media::getAsset).map(asset -> (Asset)asset.adaptTo(Asset.class)).map(DataLayerBuilder::forAsset).map(AssetDataBuilder::build).orElse(null)).build();
    }
}

