/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.LanguageNavigation;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.LanguageNavigationItemV2Impl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.via.ResourceSuperType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={LanguageNavigation.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/languagenavigation/v2/languagenavigation"})
@Exporter(name="jackson", extensions={"json"})
public class LanguageNavigationV2Impl
extends AbstractComponentImpl
implements LanguageNavigation {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/languagenavigation/v2/languagenavigation";
    @Self
    @Via(type=ResourceSuperType.class)
    private LanguageNavigation delegate;
    @Self
    private LinkHandler linkHandler;

    public List<NavigationItem> getItems() {
        return this.toLanguageNavigationItems(this.delegate.getItems());
    }

    private List<NavigationItem> toLanguageNavigationItems(List<NavigationItem> items) {
        return items.stream().map(this::toLanguageNavigationItem).collect(Collectors.toList());
    }

    private NavigationItem toLanguageNavigationItem(NavigationItem item) {
        Page page = item.getPage();
        Link link = this.linkHandler.get(page).build();
        return this.newLanguageNavigationItem(page, link, item.getLevel(), item.isActive(), item.isCurrent(), this.toLanguageNavigationItems(item.getChildren()), item.getTitle());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public String getId() {
        return this.delegate.getId();
    }

    public String getAccessibilityLabel() {
        return this.delegate.getAccessibilityLabel();
    }

    protected NavigationItem newLanguageNavigationItem(@NotNull Page page, @NotNull Link link, int level, boolean active, boolean current, @NotNull List<NavigationItem> children, @Nullable String title) {
        return new LanguageNavigationItemV2Impl(page, link, level, active, current, children, title, this.getId(), this.getParentComponent());
    }
}

