/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Navigation;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.ui.SiteRoot;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.NavigationItemV2Impl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Navigation.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/navigation/v2/navigation"})
@Exporter(name="jackson", extensions={"json"})
public class NavigationV2Impl
extends AbstractComponentImpl
implements Navigation {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/navigation/v2/navigation";
    private static final int NO_STRUCTURE_DEPTH = -1;
    @AemObject
    private Style currentStyle;
    @AemObject
    private PageManager pageManager;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private SiteRoot siteRoot;
    @Self
    private UrlHandler urlHandler;
    @Self
    private LinkHandler linkHandler;
    private List<NavigationItem> items;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String accessibilityLabel;
    private String navigationRootPath;
    private int structureDepth;
    private int structureStart;

    @PostConstruct
    private void activate() {
        boolean skipNavigationRoot;
        ValueMap properties = this.resource.getValueMap();
        this.navigationRootPath = (String)this.resource.getValueMap().get("navigationRoot", (Object)((String)this.currentStyle.get("navigationRoot", String.class)));
        this.structureDepth = (Integer)properties.get("structureDepth", (Object)((Integer)this.currentStyle.get("structureDepth", (Object)-1)));
        boolean collectAllPages = (Boolean)properties.get("collectAllPages", (Object)((Boolean)this.currentStyle.get("collectAllPages", (Object)true)));
        if (collectAllPages) {
            this.structureDepth = -1;
        }
        this.structureStart = this.currentStyle.containsKey((Object)"structureStart") || properties.containsKey((Object)"structureStart") ? (Integer)properties.get("structureStart", (Object)((Integer)this.currentStyle.get("structureStart", (Object)1))) : ((skipNavigationRoot = ((Boolean)properties.get("skipNavigationRoot", (Object)((Boolean)this.currentStyle.get("skipNavigationRoot", (Object)true)))).booleanValue()) ? 1 : 0);
    }

    public List<NavigationItem> getItems() {
        if (this.items == null) {
            this.items = this.createItems();
        }
        return this.items;
    }

    public String getAccessibilityLabel() {
        return this.accessibilityLabel;
    }

    private List<NavigationItem> createItems() {
        List<Object> result;
        Page rootPage = this.getNavigationRootPage();
        if (rootPage != null) {
            NavigationRoot navigationRoot = new NavigationRoot(rootPage, this.structureDepth);
            result = this.getNavigationTree(navigationRoot);
        } else {
            result = Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    @Nullable
    private Page getNavigationRootPage() {
        Page navigationRootPage = null;
        if (StringUtils.isBlank((CharSequence)this.navigationRootPath)) {
            navigationRootPage = this.siteRoot.getRootPage();
        } else if (StringUtils.startsWith((CharSequence)this.navigationRootPath, (CharSequence)"/")) {
            SyntheticResource configuredRootResource = new SyntheticResource(this.resourceResolver, this.navigationRootPath, "nt:unstructured");
            String rewrittenPath = this.urlHandler.rewritePathToContext((Resource)configuredRootResource);
            navigationRootPage = this.pageManager.getPage(rewrittenPath);
        } else {
            String siteRootPath = this.siteRoot.getRootPath();
            if (siteRootPath != null) {
                navigationRootPage = this.pageManager.getPage(siteRootPath + "/" + this.navigationRootPath);
            }
        }
        return navigationRootPage;
    }

    private List<NavigationItem> getNavigationTree(NavigationRoot navigationRoot) {
        ArrayList<Object> itemTree = new ArrayList<NavigationItem>();
        List<NavigationRoot> rootItems = this.getRootItems(navigationRoot);
        for (NavigationRoot rootItem : rootItems) {
            itemTree.addAll(this.getItems(rootItem, rootItem.page));
        }
        if (this.structureStart == 0) {
            Link link = this.linkHandler.get(navigationRoot.page).build();
            boolean active = this.isActive(navigationRoot.page, link);
            boolean current = this.isCurrent(navigationRoot.page, link);
            NavigationItem root = this.newNavigationItem(navigationRoot.page, link, 0, active, current, itemTree);
            itemTree = new ArrayList();
            itemTree.add(root);
        }
        return itemTree;
    }

    private List<NavigationRoot> getRootItems(NavigationRoot navigationRoot) {
        LinkedList<NavigationRoot> rootItems = new LinkedList<NavigationRoot>();
        rootItems.addLast(navigationRoot);
        if (this.structureStart > 0) {
            for (int level = 1; level != this.structureStart && !rootItems.isEmpty(); ++level) {
                for (int size = rootItems.size(); size > 0; --size) {
                    NavigationRoot item = rootItems.removeFirst();
                    Iterator it = item.page.listChildren((Filter)new PageFilter());
                    while (it.hasNext()) {
                        rootItems.addLast(new NavigationRoot((Page)it.next(), this.structureDepth));
                    }
                }
            }
        }
        return rootItems;
    }

    private List<NavigationItem> getItems(NavigationRoot navigationRoot, Page subtreeRoot) {
        ArrayList<NavigationItem> pages = new ArrayList<NavigationItem>();
        if (navigationRoot.structureDepth == -1 || subtreeRoot.getDepth() < navigationRoot.structureDepth) {
            Iterator it = subtreeRoot.listChildren((Filter)new PageFilter(false, false));
            while (it.hasNext()) {
                Page page = (Page)it.next();
                int pageLevel = page.getDepth();
                int level = pageLevel - navigationRoot.startLevel;
                List<NavigationItem> children = this.getItems(navigationRoot, page);
                Link link = this.linkHandler.get(page).build();
                boolean active = this.isActive(page, link);
                boolean current = this.isCurrent(page, link);
                if (this.structureStart == 0) {
                    --level;
                }
                pages.add(this.newNavigationItem(page, link, level, active, current, children));
            }
        }
        return pages;
    }

    private boolean isActive(@NotNull Page page, @NotNull Link link) {
        return this.isCurrent(page, link) || StringUtils.startsWith((CharSequence)this.getCurrentPage().getPath(), (CharSequence)(page.getPath() + "/"));
    }

    private boolean isCurrent(@NotNull Page page, @NotNull Link link) {
        return StringUtils.equals((CharSequence)page.getPath(), (CharSequence)this.getCurrentPage().getPath()) || this.currentPageIsRedirectTarget(link);
    }

    private boolean currentPageIsRedirectTarget(@NotNull Link link) {
        return link.getTargetPage() != null && StringUtils.equals((CharSequence)this.getCurrentPage().getPath(), (CharSequence)link.getTargetPage().getPath());
    }

    protected NavigationItem newNavigationItem(@NotNull Page page, @NotNull Link link, int level, boolean active, boolean current, @NotNull List<NavigationItem> children) {
        return new NavigationItemV2Impl(page, link, level, active, current, children, this.getId(), this.getParentComponent());
    }

    private static final class NavigationRoot {
        private final Page page;
        private final int startLevel;
        private final int structureDepth;

        private NavigationRoot(@NotNull Page navigationRoot, int configuredStructureDepth) {
            this.page = navigationRoot;
            this.startLevel = navigationRoot.getDepth();
            this.structureDepth = configuredStructureDepth >= 0 ? configuredStructureDepth + this.startLevel : -1;
        }
    }
}

