/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v3;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.List;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.PageListItemV2Impl;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.via.ResourceSuperType;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={List.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/list/v3/list"})
@Exporter(name="jackson", extensions={"json"})
public class ListV3Impl
extends AbstractComponentImpl
implements List {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/list/v3/list";
    @Self
    @Via(type=ResourceSuperType.class)
    private List delegate;
    @Self
    private LinkHandler linkHandler;

    @JsonProperty(value="items")
    @NotNull
    public Collection<ListItem> getListItems() {
        return this.getItems().stream().filter(Objects::nonNull).map(page -> this.newPageListItem((Page)page, this.linkHandler.get(page).build())).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public String getId() {
        return this.delegate.getId();
    }

    public Collection<Page> getItems() {
        return this.delegate.getItems();
    }

    public boolean linkItems() {
        return this.delegate.linkItems();
    }

    public boolean showDescription() {
        return this.delegate.showDescription();
    }

    public boolean showModificationDate() {
        return this.delegate.showModificationDate();
    }

    public String getDateFormatString() {
        return this.delegate.getDateFormatString();
    }

    public boolean displayItemAsTeaser() {
        return this.delegate.displayItemAsTeaser();
    }

    protected ListItem newPageListItem(@NotNull Page page, @NotNull Link link) {
        return new PageListItemV2Impl(page, link, this.getId(), this.getParentComponent(), this.showDescription(), this.linkItems() || this.displayItemAsTeaser());
    }
}

