/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.wcmio.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.AssetDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ImageComponentDataBuilder;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.designer.Style;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.commons.dom.Picture;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.ImageAreaV1Impl;
import io.wcm.wcm.core.components.impl.util.ComponentFeatureImageResolver;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import io.wcm.wcm.core.components.models.ResponsiveImage;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ResponsiveImage.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/wcmio/responsiveimage/v1/responsiveimage"})
@Exporter(name="jackson", extensions={"json"})
public class ResponsiveImageV1Impl
extends AbstractComponentImpl
implements ResponsiveImage {
    public static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/wcmio/responsiveimage/v1/responsiveimage";
    @AemObject
    private Style currentStyle;
    @Self
    private LinkHandler linkHandler;
    @Self
    private MediaHandler mediaHandler;
    @ValueMapValue(name="alt", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String alt;
    @ValueMapValue(name="jcr:title", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String title;
    private Link link;
    private Media media;
    private String uuid;
    private String fileReference;
    private boolean displayPopupTitle;
    private List<ImageArea> areas;

    @PostConstruct
    private void activate() {
        ValueMap properties = this.resource.getValueMap();
        this.displayPopupTitle = (Boolean)properties.get("displayPopupTitle", (Object)((Boolean)this.currentStyle.get("displayPopupTitle", (Object)true)));
        boolean isDecorative = (Boolean)properties.get("isDecorative", (Object)((Boolean)this.currentStyle.get("isDecorative", (Object)false)));
        this.link = isDecorative ? this.linkHandler.invalid() : HandlerUnwrapper.get(this.linkHandler, this.resource).build();
        this.media = new ComponentFeatureImageResolver(this.resource, this.getCurrentPage(), this.currentStyle, this.mediaHandler).targetPage(this.link.getTargetPage()).mediaHandlerProperty("itemprop", "contentUrl").mediaHandlerProperty("data-cmp-hook-image", "image").mediaHandlerProperty("cssClass", "cmp-wcmio-responsiveimage__image").buildMedia();
        if (this.media.isValid() && !this.media.getRendition().isImage()) {
            this.media = this.mediaHandler.invalid();
        }
        if (this.media.isValid()) {
            this.initPropertiesFromDamAsset(properties);
            this.areas = ImageAreaV1Impl.convertMap(this.media.getMap());
            if (this.displayPopupTitle() && this.media.getElement() != null) {
                ResponsiveImageV1Impl.setImageTitle(this.media.getElement(), this.getTitle());
            }
        }
    }

    private void initPropertiesFromDamAsset(ValueMap properties) {
        Asset damAsset;
        io.wcm.handler.media.Asset asset = this.media.getAsset();
        if (asset != null && (damAsset = (Asset)asset.adaptTo(Asset.class)) != null) {
            String assetTitle;
            boolean titleFromAsset = (Boolean)properties.get("titleValueFromDAM", (Object)((Boolean)this.currentStyle.get("titleValueFromDAM", (Object)true)));
            boolean uuidDisabled = (Boolean)this.currentStyle.get("uuidDisabled", (Object)false);
            this.fileReference = damAsset.getPath();
            this.alt = asset.getAltText();
            if (!uuidDisabled) {
                this.uuid = damAsset.getID();
            }
            if (titleFromAsset && StringUtils.isNotEmpty((CharSequence)(assetTitle = asset.getTitle()))) {
                this.title = assetTitle;
            }
        }
    }

    private static void setImageTitle(HtmlElement<?> element, String title) {
        if (element == null) {
            return;
        }
        if (element instanceof Picture || element instanceof Image) {
            element.setTitle(title);
        } else {
            List children = element.getChildren();
            for (HtmlElement child : children) {
                ResponsiveImageV1Impl.setImageTitle(child, title);
            }
        }
    }

    @Override
    @NotNull
    public Link getLinkObject() {
        return this.link;
    }

    @Override
    @NotNull
    public Media getMediaObject() {
        return this.media;
    }

    @Override
    public String getAlt() {
        return this.alt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean displayPopupTitle() {
        return this.displayPopupTitle;
    }

    @Override
    public String getFileReference() {
        return this.fileReference;
    }

    @Override
    public List<ImageArea> getAreas() {
        return this.areas;
    }

    @NotNull
    protected ImageData getComponentData() {
        return ((ImageComponentDataBuilder)((ImageComponentDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asImageComponent().withTitle(this::getTitle)).withLinkUrl(this::getLinkURL)).withAssetData(() -> Optional.of(this.media).filter(Media::isValid).map(Media::getAsset).map(asset -> (Asset)AdaptTo.notNull((Adaptable)asset, Asset.class)).map(DataLayerBuilder::forAsset).map(AssetDataBuilder::build).orElse(null)).build();
    }
}

