/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.util;

import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.MediaHandler;
import io.wcm.wcm.core.components.impl.util.CoreResourceWrapper;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentFeatureImageResolver {
    private final Resource componentResource;
    private final Page currentPage;
    private final MediaHandler mediaHandler;
    private final Map<String, Object> mediaHandlerProperties = new HashMap<String, Object>();
    private final boolean imageFromPageImage;
    private final boolean altValueFromPageImage;
    private final boolean altValueFromDam;
    private final boolean isDecorative;
    private final String componentAltText;
    private Page targetPage;

    public ComponentFeatureImageResolver(@NotNull Resource componentResource, @NotNull Page currentPage, @NotNull Style currentStyle, @NotNull MediaHandler mediaHandler) {
        this.componentResource = componentResource;
        this.currentPage = currentPage;
        this.mediaHandler = mediaHandler;
        ValueMap props = componentResource.getValueMap();
        this.imageFromPageImage = (Boolean)props.get("imageFromPageImage", (Object)false);
        this.altValueFromPageImage = (Boolean)props.get("altValueFromPageImage", (Object)false);
        this.altValueFromDam = (Boolean)props.get("altValueFromDAM", (Object)false);
        this.isDecorative = (Boolean)props.get("isDecorative", (Object)((Boolean)currentStyle.get("isDecorative", (Object)false)));
        this.componentAltText = (String)props.get("alt", String.class);
    }

    public ComponentFeatureImageResolver targetPage(@Nullable Page value) {
        this.targetPage = value;
        return this;
    }

    public ComponentFeatureImageResolver mediaHandlerProperty(@NotNull String key, @NotNull String value) {
        this.mediaHandlerProperties.put(key, value);
        return this;
    }

    @NotNull
    public Media buildMedia() {
        Media media;
        if (this.imageFromPageImage) {
            Resource featuredImageResource;
            if (this.targetPage != null) {
                featuredImageResource = ComponentUtils.getFeaturedImage((Page)this.targetPage);
                media = this.buildMedia(this.wrapFeatureImageResource(featuredImageResource));
            } else {
                media = this.mediaHandler.invalid();
            }
            if (!media.isValid() && this.isComponentInCurrentPage()) {
                featuredImageResource = ComponentUtils.getFeaturedImage((Page)this.currentPage);
                media = this.buildMedia(this.wrapFeatureImageResource(featuredImageResource));
            }
        } else {
            media = this.buildMedia(this.componentResource);
        }
        return media;
    }

    @Nullable
    private Resource wrapFeatureImageResource(@Nullable Resource resource) {
        if (resource == null) {
            return null;
        }
        return new CoreResourceWrapper(resource, HandlerUnwrapper.getResourceType(this.componentResource));
    }

    @NotNull
    private Media buildMedia(@Nullable Resource mediaResource) {
        if (mediaResource == null) {
            return this.mediaHandler.invalid();
        }
        MediaBuilder builder = HandlerUnwrapper.get(this.mediaHandler, mediaResource);
        if (this.isDecorative) {
            builder.decorative(true);
        } else if (!this.altValueFromPageImage && !this.altValueFromDam) {
            builder.altText(this.componentAltText);
        }
        this.mediaHandlerProperties.entrySet().forEach(entry -> builder.property((String)entry.getKey(), entry.getValue()));
        return builder.build();
    }

    private boolean isComponentInCurrentPage() {
        String pageContentPath = this.currentPage.getContentResource().getPath();
        String templatePath = (String)this.currentPage.getProperties().get("cq:template", String.class);
        return this.isChildResource(pageContentPath) || this.isChildResource(templatePath);
    }

    private boolean isChildResource(@Nullable String parentPath) {
        if (parentPath == null) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.componentResource.getPath(), (CharSequence)(parentPath + "/"));
    }
}

