/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Exporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Exporter(name="jackson", extensions={"json"})
public class CoreResourceWrapper
extends ResourceWrapper {
    private ValueMap valueMap;
    private String overriddenResourceType;

    public CoreResourceWrapper(@NotNull Resource resource, @NotNull String overriddenResourceType) {
        this(resource, overriddenResourceType, null, null);
    }

    public CoreResourceWrapper(@NotNull Resource resource, @NotNull String overriddenResourceType, @Nullable Map<String, Object> overriddenProperties, @Nullable Set<String> hiddenProperties) {
        super(resource);
        if (StringUtils.isEmpty((CharSequence)overriddenResourceType)) {
            throw new IllegalArgumentException("The " + CoreResourceWrapper.class.getName() + " needs to override the resource type of the wrapped resource, but the resourceType argument was null or empty.");
        }
        this.overriddenResourceType = overriddenResourceType;
        this.valueMap = new ValueMapDecorator(new HashMap(resource.getValueMap()));
        this.valueMap.put((Object)"sling:resourceType", (Object)overriddenResourceType);
        if (overriddenProperties != null) {
            this.valueMap.putAll(overriddenProperties);
        }
        if (hiddenProperties != null) {
            hiddenProperties.forEach(arg_0 -> this.valueMap.remove(arg_0));
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.valueMap;
        }
        return (AdapterType)super.adaptTo(type);
    }

    @NotNull
    public ValueMap getValueMap() {
        return this.valueMap;
    }

    @NotNull
    public String getResourceType() {
        return this.overriddenResourceType;
    }

    public boolean isResourceType(String resourceType) {
        return this.getResourceResolver().isResourceType((Resource)this, resourceType);
    }
}

