/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.helpers;

import com.adobe.cq.wcm.core.components.models.Container;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ContainerData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerImpl
extends AbstractComponentImpl
implements Container {
    @AemObject
    private Style currentStyle;
    @Self
    private MediaHandler mediaHandler;
    private String backgroundStyle;

    @Nullable
    public String getBackgroundStyle() {
        if (this.backgroundStyle == null) {
            this.backgroundStyle = this.buildBackgroundStyle();
        }
        return StringUtils.trimToNull((String)this.backgroundStyle);
    }

    @NotNull
    private String buildBackgroundStyle() {
        StringBuilder style = new StringBuilder();
        boolean backgroundColorEnabled = (Boolean)this.currentStyle.get("backgroundColorEnabled", (Object)false);
        boolean backgroundImageEnabled = (Boolean)this.currentStyle.get("backgroundImageEnabled", (Object)false);
        if (backgroundImageEnabled) {
            style.append(this.buildBackgroundStyle_BackgroundImage());
        }
        if (backgroundColorEnabled) {
            style.append(this.buildBackgroundStyle_BackgroundColor());
        }
        return style.toString();
    }

    @NotNull
    private String buildBackgroundStyle_BackgroundImage() {
        Media media = HandlerUnwrapper.get(this.mediaHandler, this.resource).refProperty("backgroundImageReference").build();
        if (media.isValid()) {
            return "background-image:url(" + media.getUrl() + ");background-size:cover;background-repeat:no-repeat;";
        }
        return "";
    }

    @NotNull
    private String buildBackgroundStyle_BackgroundColor() {
        ValueMap properties = this.resource.getValueMap();
        String backgroundColor = (String)properties.get("backgroundColor", String.class);
        if (!StringUtils.isBlank((CharSequence)backgroundColor)) {
            return "background-color:" + backgroundColor + ";";
        }
        return "";
    }

    @NotNull
    protected ContainerData getComponentData() {
        return DataLayerBuilder.extending((ComponentData)super.getComponentData()).asContainer().withShownItems(this::getDataLayerShownItems).build();
    }

    @JsonIgnore
    protected abstract String[] getDataLayerShownItems();
}

