/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.helpers;

import com.adobe.cq.wcm.core.components.models.ImageArea;
import io.wcm.handler.link.Link;
import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;

public class ImageAreaV2Impl
implements ImageArea {
    private final ImageMapArea delegate;
    private final LinkWrapper link;

    public ImageAreaV2Impl(ImageMapArea delegate) {
        this.delegate = delegate;
        Link delegateLink = this.toLink(delegate.getLink());
        this.link = delegateLink != null ? new LinkWrapper(delegateLink) : null;
    }

    private Link toLink(Object linkObject) {
        if (linkObject instanceof Link) {
            return (Link)linkObject;
        }
        return null;
    }

    public String getShape() {
        return this.delegate.getShape();
    }

    public String getCoordinates() {
        return this.delegate.getCoordinates();
    }

    public String getRelativeCoordinates() {
        return this.delegate.getRelativeCoordinates();
    }

    public String getHref() {
        return this.delegate.getLinkUrl();
    }

    public String getTarget() {
        return StringUtils.defaultString((String)this.delegate.getLinkWindowTarget());
    }

    public String getAlt() {
        return StringUtils.defaultString((String)this.delegate.getAltText());
    }

    public com.adobe.cq.wcm.core.components.commons.link.Link getLink() {
        if (this.link != null) {
            return this.link.orNull();
        }
        return null;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"link"});
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[]{"link"});
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Nullable
    public static List<ImageArea> convertMap(@Nullable List<ImageMapArea> imageMap) {
        if (imageMap == null) {
            return null;
        }
        return imageMap.stream().map(ImageAreaV2Impl::new).collect(Collectors.toList());
    }
}

