/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.helpers;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractListItemImpl;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkListItemV2Impl
extends AbstractListItemImpl
implements ListItem {
    private final String title;
    protected final LinkWrapper link;
    private final String itemIdPrefix;

    public LinkListItemV2Impl(@NotNull String title, @NotNull LinkWrapper link, @NotNull String itemIdPrefix, @Nullable String parentId, @Nullable Component parentComponent, @NotNull Resource contextResource) {
        super(LinkListItemV2Impl.getLinkRequestResource(link, contextResource), parentId, parentComponent);
        this.title = title;
        this.link = link;
        this.itemIdPrefix = itemIdPrefix;
    }

    @NotNull
    private static Resource getLinkRequestResource(@NotNull LinkWrapper link, @NotNull Resource contextResource) {
        Resource resource = link.getLinkObject().getLinkRequest().getResource();
        if (resource == null) {
            resource = new SyntheticLinkResource(contextResource.getResourceResolver(), contextResource.getPath());
        }
        return resource;
    }

    @Nullable
    public Link getLink() {
        return this.link.orNull();
    }

    @Deprecated(forRemoval=true)
    @JsonIgnore
    public String getURL() {
        return this.link.getURL();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    protected String getItemIdPrefix() {
        return this.itemIdPrefix;
    }

    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(this.link::getURL)).build();
    }
}

