/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.helpers;

import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.link.Link;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractListItemImpl;
import io.wcm.wcm.core.components.impl.util.CoreResourceWrapper;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageListItemV4Impl
extends AbstractListItemImpl
implements ListItem {
    private final Page page;
    protected final LinkWrapper link;
    private final Component parentComponent;
    private final boolean showDescription;
    private final boolean linkItems;
    private Resource teaserResource;
    private String linkText;
    private static final Logger log = LoggerFactory.getLogger(PageListItemV4Impl.class);

    public PageListItemV4Impl(@NotNull Page page, @NotNull Link link, @Nullable String parentId, @Nullable Component parentComponent, boolean showDescription, boolean linkItems, @Nullable String linkText) {
        super(page.getContentResource(), parentId, parentComponent);
        this.page = page;
        this.link = new LinkWrapper(link);
        this.parentComponent = parentComponent;
        this.showDescription = showDescription;
        this.linkItems = linkItems;
        this.linkText = linkText;
    }

    public PageListItemV4Impl(@NotNull Page page, @NotNull Link link, @Nullable String parentId, @Nullable Component parentComponent) {
        this(page, link, parentId, parentComponent, false, false, null);
    }

    @Nullable
    public com.adobe.cq.wcm.core.components.commons.link.Link getLink() {
        return this.link.orNull();
    }

    @Deprecated(forRemoval=true, since="1.9.0-2.17.2")
    @JsonIgnore
    public String getURL() {
        return this.link.getURL();
    }

    public String getTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.linkText)) {
            return this.linkText;
        }
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.page.getNavigationTitle(), this.page.getPageTitle(), this.page.getTitle(), this.page.getName()});
    }

    public String getDescription() {
        return this.page.getDescription();
    }

    public Calendar getLastModified() {
        return this.page.getLastModified();
    }

    public String getPath() {
        return this.page.getPath();
    }

    @JsonIgnore
    public String getName() {
        return this.page.getName();
    }

    @JsonIgnore
    @Nullable
    public Resource getTeaserResource() {
        if (this.teaserResource == null && this.parentComponent != null) {
            String delegateResourceType = (String)this.parentComponent.getProperties().get("teaserDelegate", String.class);
            if (delegateResourceType == null || StringUtils.isEmpty((CharSequence)delegateResourceType)) {
                log.error("In order for list rendering delegation to work correctly you need to set up the teaserDelegate property on the {} component; its value has to point to the resource type of a teaser component.", (Object)this.parentComponent.getPath());
            } else {
                this.teaserResource = this.buildTeaserResource(delegateResourceType);
            }
        }
        return this.teaserResource;
    }

    private Resource buildTeaserResource(@NotNull String delegateResourceType) {
        HashMap<String, Object> overriddenProperties = new HashMap<String, Object>();
        HashSet<String> hiddenProperties = new HashSet<String>();
        Resource resourceToBeWrapped = ComponentUtils.getFeaturedImage((Page)this.page);
        if (resourceToBeWrapped != null) {
            overriddenProperties.put("jcr:title", this.getTitle());
            if (this.showDescription) {
                overriddenProperties.put("jcr:description", this.getDescription());
            }
        } else {
            resourceToBeWrapped = this.page.getContentResource();
            if (resourceToBeWrapped == null) {
                return null;
            }
            if (!this.showDescription) {
                hiddenProperties.add("jcr:description");
            }
        }
        if (this.linkItems) {
            overriddenProperties.put("linkType", "internal");
            overriddenProperties.put("linkContentRef", this.getPath());
        }
        return new CoreResourceWrapper(resourceToBeWrapped, resourceToBeWrapped.getPath(), delegateResourceType, overriddenProperties, hiddenProperties);
    }

    @JsonIgnore
    public Page getPage() {
        return this.page;
    }

    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(this.link::getURL)).build();
    }
}

