/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import io.wcm.handler.link.Link;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.Rendition;
import io.wcm.wcm.core.components.impl.models.helpers.ImageAreaV1Impl;
import io.wcm.wcm.core.components.impl.models.v3.ImageV3Impl;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import io.wcm.wcm.core.components.models.mixin.LinkMixin;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/image/v2/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageV2Impl
extends ImageV3Impl
implements LinkMixin {
    public static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/image/v2/image";

    @Override
    protected Media buildMedia(boolean altFromAsset) {
        return HandlerUnwrapper.get(this.mediaHandler, this.resource).dynamicMediaDisabled(true).decorative(this.isDecorative).forceAltValueFromAsset(altFromAsset).build();
    }

    @Override
    protected List<ImageArea> buildAreas() {
        return ImageAreaV1Impl.convertMap(this.media.getMap());
    }

    @Override
    protected List<Long> buildRenditionWidths() {
        Rendition rendition = this.media.getRendition();
        if (rendition == null) {
            return List.of();
        }
        long maxWidth = rendition.getWidth();
        String[] configuredWidths = (String[])this.currentStyle.get("allowedRenditionWidths", (Object)new String[0]);
        return Arrays.stream(configuredWidths).map(NumberUtils::toLong).filter(width -> width > 0L && width <= maxWidth).sorted().collect(Collectors.toList());
    }

    @Override
    protected String buildSrcPattern() {
        String mediaUrl = this.media.getUrl();
        String extension = StringUtils.substringAfterLast((String)mediaUrl, (String)".");
        String fileName = StringUtils.substringAfterLast((String)mediaUrl, (String)"/");
        StringBuilder suffix = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.imageCrop)) {
            suffix.append(this.imageCrop).append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.imageRotate)) {
            suffix.append(this.imageRotate).append("/");
        }
        suffix.append(fileName);
        String url = this.urlHandler.get(this.resource).selectors("imgwidth").extension(extension).suffix(suffix.toString()).buildExternalResourceUrl();
        return StringUtils.replace((String)url, (String)".imgwidth.", (String)".imgwidth{.width}.");
    }

    @Override
    @NotNull
    public Link getLinkObject() {
        return this.link.getLinkObject();
    }

    @Override
    public String getSrc() {
        long noScriptWidth = this.getNoScriptWidth();
        if (noScriptWidth > 0L) {
            return StringUtils.replace((String)this.srcPattern, (String)"{.width}", (String)("." + noScriptWidth));
        }
        return this.media.getUrl();
    }

    private long getNoScriptWidth() {
        if (this.widths.isEmpty()) {
            return 0L;
        }
        return (Long)this.widths.get((int)Math.round((double)this.widths.size() / 2.0 - 0.5));
    }
}

