/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.richtext.RichTextHandler;
import io.wcm.handler.richtext.TextMode;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.LinkListItemV2Impl;
import io.wcm.wcm.core.components.impl.util.ComponentFeatureImageResolver;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import io.wcm.wcm.core.components.models.mixin.MediaMixin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Teaser.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/teaser/v2/teaser"})
@Exporter(name="jackson", extensions={"json"})
public class TeaserV2Impl
extends AbstractComponentImpl
implements Teaser,
MediaMixin {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/teaser/v2/teaser";
    private static final String CTA_ID_PREFIX = "cta";
    @AemObject
    private Style currentStyle;
    @Self
    private MediaHandler mediaHandler;
    @Self
    private LinkHandler linkHandler;
    @Self
    private RichTextHandler richTextHandler;
    private Media media;
    protected LinkWrapper link;
    private final List<ListItem> actions = new ArrayList<ListItem>();
    private Page targetPage;
    private String pretitle;
    private String title;
    private String description;
    private String titleType;
    private boolean showTitleType;
    private boolean actionsEnabled;
    private boolean imageLinkHidden;
    private boolean titleLinkHidden;

    @PostConstruct
    private void activate() {
        Resource actionsNode;
        ValueMap properties = this.resource.getValueMap();
        boolean pretitleHidden = (Boolean)this.currentStyle.get("pretitleHidden", (Object)false);
        boolean titleHidden = (Boolean)this.currentStyle.get("titleHidden", (Object)false);
        boolean descriptionHidden = (Boolean)this.currentStyle.get("descriptionHidden", (Object)false);
        this.titleType = (String)this.currentStyle.get("titleType", String.class);
        this.showTitleType = (Boolean)this.currentStyle.get("showTitleType", (Object)false);
        this.imageLinkHidden = (Boolean)this.currentStyle.get("imageLinkHidden", (Object)false);
        this.titleLinkHidden = (Boolean)this.currentStyle.get("titleLinkHidden", (Object)false);
        boolean actionsDisabled = (Boolean)this.currentStyle.get("actionsDisabled", (Object)false);
        this.actionsEnabled = (Boolean)properties.get("actionsEnabled", (Object)this.getActionsEnabledDefault()) != false && !actionsDisabled;
        boolean titleFromPage = (Boolean)properties.get("titleFromPage", (Object)false);
        boolean descriptionFromPage = (Boolean)properties.get("descriptionFromPage", (Object)false);
        if (this.actionsEnabled && (actionsNode = this.resource.getChild("actions")) != null) {
            for (Resource actionResource : actionsNode.getChildren()) {
                String actionTitle = (String)actionResource.getValueMap().get("text", String.class);
                LinkWrapper actionLink = new LinkWrapper(this.linkHandler.get(actionResource).build());
                if (actionTitle == null || !actionLink.isValid()) continue;
                this.actions.add(this.newLinkListItem(actionTitle, actionLink, CTA_ID_PREFIX));
                if (this.targetPage != null) continue;
                this.targetPage = actionLink.getLinkObject().getTargetPage();
            }
        }
        if (this.actionsEnabled && !this.actions.isEmpty()) {
            this.link = new LinkWrapper(this.linkHandler.invalid());
        } else {
            this.link = new LinkWrapper(HandlerUnwrapper.get(this.linkHandler, this.resource).build());
            this.targetPage = this.link.getLinkObject().getTargetPage();
        }
        this.media = new ComponentFeatureImageResolver(this.resource, this.getCurrentPage(), this.currentStyle, this.mediaHandler).targetPage(this.targetPage).mediaHandlerProperty("cssClass", "cmp-image__image").buildMedia();
        if (!pretitleHidden) {
            this.pretitle = (String)properties.get("pretitle", String.class);
        }
        if (!titleHidden) {
            if (titleFromPage) {
                if (this.targetPage != null) {
                    this.title = (String)StringUtils.defaultIfEmpty((CharSequence)this.targetPage.getPageTitle(), (CharSequence)this.targetPage.getTitle());
                }
            } else {
                this.title = (String)properties.get("jcr:title", String.class);
            }
        }
        if (!descriptionHidden) {
            if (descriptionFromPage) {
                if (this.targetPage != null) {
                    this.description = this.targetPage.getDescription();
                    this.description = this.richTextHandler.get(this.description).textMode(TextMode.PLAIN).buildMarkup();
                }
            } else {
                this.description = (String)properties.get("jcr:description", String.class);
                this.description = this.richTextHandler.get(this.description).textMode(TextMode.XHTML).buildMarkup();
            }
        }
    }

    protected boolean getActionsEnabledDefault() {
        return true;
    }

    @Override
    @NotNull
    public Media getMediaObject() {
        return this.media;
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public List<ListItem> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public Link getLink() {
        return this.link.orNull();
    }

    @Deprecated(forRemoval=true)
    @JsonIgnore
    public String getLinkURL() {
        return this.link.getURL();
    }

    public boolean isImageLinkHidden() {
        return this.imageLinkHidden;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPretitle() {
        return this.pretitle;
    }

    public boolean isTitleLinkHidden() {
        return this.titleLinkHidden;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitleType() {
        if (this.showTitleType) {
            this.titleType = (String)this.resource.getValueMap().get("titleType", (Object)this.titleType);
        }
        return this.titleType;
    }

    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asComponent().withTitle(this::getTitle)).withLinkUrl(this.link::getURL)).withDescription(this::getDescription)).build();
    }

    protected ListItem newLinkListItem(@NotNull String newTitle, @NotNull LinkWrapper newLink, @NotNull String itemIdPrefix) {
        return new LinkListItemV2Impl(newTitle, newLink, itemIdPrefix, this.getId(), this.getParentComponent(), this.resource);
    }
}

