/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v3;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Breadcrumb;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.url.ui.SiteRoot;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.v3.BreadcrumbV3ItemImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Breadcrumb.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/breadcrumb/v3/breadcrumb"})
@Exporter(name="jackson", extensions={"json"})
public class BreadcrumbV3Impl
extends AbstractComponentImpl
implements Breadcrumb {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/breadcrumb/v3/breadcrumb";
    @AemObject
    private Style currentStyle;
    @Self
    private SiteRoot siteRoot;
    @Self
    private LinkHandler linkHandler;
    private List<NavigationItem> items;
    private boolean showHidden;
    private boolean hideCurrent;

    @PostConstruct
    private void activate() {
        ValueMap properties = this.resource.getValueMap();
        this.showHidden = (Boolean)properties.get("showHidden", (Object)((Boolean)this.currentStyle.get("showHidden", (Object)false)));
        this.hideCurrent = (Boolean)properties.get("hideCurrent", (Object)((Boolean)this.currentStyle.get("hideCurrent", (Object)false)));
    }

    public Collection<NavigationItem> getItems() {
        if (this.items == null) {
            this.items = this.createItems();
        }
        return Collections.unmodifiableList(this.items);
    }

    private List<NavigationItem> createItems() {
        LinkedList<NavigationItem> result = new LinkedList<NavigationItem>();
        for (Page page = this.getCurrentPage(); page != null; page = page.getParent()) {
            boolean isCurrentPage = StringUtils.equals((CharSequence)page.getPath(), (CharSequence)this.getCurrentPage().getPath());
            if (!(isCurrentPage && this.hideCurrent || !this.checkIfNotHidden(page))) {
                Link link = this.linkHandler.get(page).build();
                NavigationItem navigationItem = this.newNavigationItem(page, link, isCurrentPage);
                result.add(0, navigationItem);
            }
            if (this.siteRoot.isRootPage(page)) break;
        }
        return result;
    }

    private boolean checkIfNotHidden(Page page) {
        return !page.isHideInNav() || this.showHidden;
    }

    protected NavigationItem newNavigationItem(@NotNull Page page, @NotNull Link link, boolean current) {
        return new BreadcrumbV3ItemImpl(page, link, page.getDepth(), current, Collections.emptyList(), this.getId(), this.getParentComponent());
    }
}

