/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v3;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.AssetDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ImageComponentDataBuilder;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.ImageAreaV2Impl;
import io.wcm.wcm.core.components.impl.util.ComponentFeatureImageResolver;
import io.wcm.wcm.core.components.impl.util.HandlerUnwrapper;
import io.wcm.wcm.core.components.models.mixin.MediaMixin;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/image/v3/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageV3Impl
extends AbstractComponentImpl
implements Image,
MediaMixin {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/image/v3/image";
    public static final String WIDTH_PLACEHOLDER = "{.width}";
    @AemObject
    protected Style currentStyle;
    @Self
    protected LinkHandler linkHandler;
    @Self
    protected MediaHandler mediaHandler;
    @Self
    protected UrlHandler urlHandler;
    @ValueMapValue(name="alt", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String alt;
    @ValueMapValue(name="jcr:title", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String imageCrop;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String imageRotate;
    protected LinkWrapper link;
    protected Media media;
    protected String uuid;
    protected String fileReference;
    protected boolean displayPopupTitle;
    protected boolean enableLazyLoading;
    protected int lazyThreshold;
    protected boolean isDecorative;
    protected List<ImageArea> areas;
    protected List<Long> widths = Collections.emptyList();
    protected String srcPattern;

    @PostConstruct
    private void activate() {
        ValueMap properties = this.resource.getValueMap();
        this.displayPopupTitle = (Boolean)properties.get("displayPopupTitle", (Object)((Boolean)this.currentStyle.get("displayPopupTitle", (Object)true)));
        this.enableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)true) == false;
        this.lazyThreshold = (Integer)this.currentStyle.get("lazyThreshold", (Object)0);
        this.isDecorative = (Boolean)properties.get("isDecorative", (Object)((Boolean)this.currentStyle.get("isDecorative", (Object)false)));
        boolean altFromAsset = (Boolean)properties.get("altValueFromDAM", (Object)((Boolean)this.currentStyle.get("altValueFromDAM", (Object)true)));
        this.link = this.isDecorative ? new LinkWrapper(this.linkHandler.invalid()) : new LinkWrapper(HandlerUnwrapper.get(this.linkHandler, this.resource).build());
        this.media = this.buildMedia(altFromAsset);
        Rendition rendition = this.media.getRendition();
        if (this.media.isValid() && (rendition == null || !rendition.isImage())) {
            this.media = this.mediaHandler.invalid();
        }
        if (this.media.isValid()) {
            this.initPropertiesFromDamAsset(properties);
            this.widths = this.buildRenditionWidths();
            this.srcPattern = this.buildSrcPattern();
            this.areas = this.buildAreas();
        }
    }

    protected Media buildMedia(boolean altFromAsset) {
        ComponentFeatureImageResolver imageResolver = new ComponentFeatureImageResolver(this.resource, this.getCurrentPage(), this.currentStyle, this.mediaHandler).targetPage(this.getCurrentPage()).altValueFromDam(altFromAsset).mediaHandlerProperty("cssClass", "cmp-image__image").mediaHandlerProperty("itemprop", "contentUrl");
        String imageTitle = this.title;
        if (this.displayPopupTitle && imageTitle != null) {
            imageResolver.mediaHandlerProperty("title", imageTitle);
        }
        return imageResolver.buildMedia();
    }

    protected List<ImageArea> buildAreas() {
        return ImageAreaV2Impl.convertMap(this.media.getMap());
    }

    private void initPropertiesFromDamAsset(ValueMap properties) {
        io.wcm.handler.media.Asset asset = this.media.getAsset();
        if (asset != null) {
            if (!StringUtils.equals((CharSequence)this.media.getMediaSource().getId(), (CharSequence)"inline")) {
                this.fileReference = asset.getPath();
            }
            this.alt = asset.getAltText();
            Asset damAsset = (Asset)asset.adaptTo(Asset.class);
            if (damAsset != null) {
                String assetTitle;
                boolean titleFromAsset = (Boolean)properties.get("titleValueFromDAM", (Object)((Boolean)this.currentStyle.get("titleValueFromDAM", (Object)true)));
                boolean uuidDisabled = (Boolean)this.currentStyle.get("uuidDisabled", (Object)false);
                if (!uuidDisabled) {
                    this.uuid = damAsset.getID();
                }
                if (titleFromAsset && StringUtils.isNotEmpty((CharSequence)(assetTitle = asset.getTitle()))) {
                    this.title = assetTitle;
                }
            }
        }
    }

    protected List<Long> buildRenditionWidths() {
        Rendition rendition = this.media.getRendition();
        if (rendition == null) {
            return List.of();
        }
        double primaryRatio = rendition.getRatio();
        return this.media.getRenditions().stream().filter(item -> Ratio.matches((double)item.getRatio(), (double)primaryRatio)).map(Rendition::getWidth).distinct().sorted().collect(Collectors.toList());
    }

    protected String buildSrcPattern() {
        Rendition rendition = this.media.getRendition();
        if (rendition == null || !rendition.isImage() || rendition.isVectorImage()) {
            return null;
        }
        UriTemplate uriTempalte = rendition.getUriTemplate(UriTemplateType.SCALE_WIDTH);
        return StringUtils.replace((String)uriTempalte.getUriTemplate(), (String)"{width}", (String)WIDTH_PLACEHOLDER);
    }

    @Override
    @NotNull
    public Media getMediaObject() {
        return this.media;
    }

    public String getSrc() {
        return this.media.getUrl();
    }

    public String getAlt() {
        return this.alt;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Link getImageLink() {
        return this.link.orNull();
    }

    @Deprecated(forRemoval=true)
    public String getLink() {
        return this.link.getURL();
    }

    public boolean displayPopupTitle() {
        return this.displayPopupTitle;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public boolean isLazyEnabled() {
        return this.enableLazyLoading;
    }

    public int getLazyThreshold() {
        return this.lazyThreshold;
    }

    public String getSrcUriTemplate() {
        return this.srcPattern;
    }

    public int @NotNull [] getWidths() {
        return this.widths.stream().mapToInt(Long::intValue).toArray();
    }

    public List<ImageArea> getAreas() {
        return this.areas;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    public String getWidth() {
        return null;
    }

    public String getHeight() {
        return null;
    }

    @Nullable
    public String getSizes() {
        return null;
    }

    public String getSrcset() {
        return null;
    }

    public String getSmartCropRendition() {
        return null;
    }

    public boolean isDmImage() {
        return false;
    }

    @JsonIgnore
    @NotNull
    public ImageData getComponentData() {
        return ((ImageComponentDataBuilder)((ImageComponentDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asImageComponent().withTitle(this::getTitle)).withLinkUrl(() -> this.link.getLinkObject().getUrl())).withAssetData(() -> Optional.of(this.media).filter(Media::isValid).map(Media::getAsset).map(asset -> (Asset)asset.adaptTo(Asset.class)).map(DataLayerBuilder::forAsset).map(AssetDataBuilder::build).orElse(null)).build();
    }
}

