/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.models.v4;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.List;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkHandler;
import io.wcm.wcm.core.components.commons.link.LinkWrapper;
import io.wcm.wcm.core.components.impl.models.helpers.AbstractComponentImpl;
import io.wcm.wcm.core.components.impl.models.helpers.LinkListItemV2Impl;
import io.wcm.wcm.core.components.impl.models.helpers.PageListItemV4Impl;
import java.text.Collator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.via.ResourceSuperType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={List.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/core/components/list/v4/list"})
@Exporter(name="jackson", extensions={"json"})
public class ListV4Impl
extends AbstractComponentImpl
implements List {
    static final String RESOURCE_TYPE = "wcm-io/wcm/core/components/list/v4/list";
    static final String SOURCE_STATIC = "static";
    static final String ORDERBY_TITLE = "title";
    static final String ORDERBY_MODIFIED = "modified";
    static final String SORTORDER_DESC = "desc";
    private Collection<ListItem> staticListItems;
    @Self
    @Via(type=ResourceSuperType.class)
    private List delegate;
    @Self
    private LinkHandler linkHandler;

    @JsonProperty(value="items")
    @NotNull
    public Collection<ListItem> getListItems() {
        Resource staticItems;
        if (this.staticListItems != null) {
            return this.staticListItems;
        }
        if (this.isListSourceStatic() && (staticItems = this.resource.getChild(SOURCE_STATIC)) != null) {
            this.staticListItems = this.getStaticListItems(staticItems);
            return this.staticListItems;
        }
        return this.transformToPageListItems(this.getItems());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public String getId() {
        return this.delegate.getId();
    }

    public Collection<Page> getItems() {
        return this.delegate.getItems();
    }

    public boolean linkItems() {
        return this.delegate.linkItems();
    }

    public boolean showDescription() {
        return this.delegate.showDescription();
    }

    public boolean showModificationDate() {
        return this.delegate.showModificationDate();
    }

    public String getDateFormatString() {
        return this.delegate.getDateFormatString();
    }

    public boolean displayItemAsTeaser() {
        return this.delegate.displayItemAsTeaser();
    }

    private boolean isListSourceStatic() {
        String source = (String)this.resource.getValueMap().get("listFrom", String.class);
        return StringUtils.equals((CharSequence)source, (CharSequence)SOURCE_STATIC);
    }

    private Collection<ListItem> getStaticListItems(@NotNull Resource staticItemsResource) {
        int direction;
        Stream<Resource> itemResources = StreamSupport.stream(staticItemsResource.getChildren().spliterator(), false);
        Stream<ListItem> listItems = itemResources.map(this::toLinkListItem).filter(Objects::nonNull);
        ValueMap properties = this.resource.getValueMap();
        String orderBy = (String)properties.get("orderBy", String.class);
        String sortOrder = (String)properties.get("sortOrder", String.class);
        int n = direction = StringUtils.equalsIgnoreCase((CharSequence)sortOrder, (CharSequence)SORTORDER_DESC) ? -1 : 1;
        if (StringUtils.equals((CharSequence)orderBy, (CharSequence)ORDERBY_TITLE)) {
            Comparator<Object> titleComparator = Comparator.nullsLast(this.getCollator());
            listItems = listItems.sorted((item1, item2) -> direction * titleComparator.compare(item1.getTitle(), item2.getTitle()));
        } else if (StringUtils.equals((CharSequence)orderBy, (CharSequence)ORDERBY_MODIFIED)) {
            listItems = listItems.sorted((item1, item2) -> direction * ObjectUtils.compare((Comparable)this.getLastModifiedDate((ListItem)item1), (Comparable)this.getLastModifiedDate((ListItem)item2), (boolean)true));
        }
        return listItems.collect(Collectors.toList());
    }

    private Collator getCollator() {
        Locale locale = Locale.US;
        Page currentPage = this.getCurrentPage();
        if (currentPage != null) {
            locale = currentPage.getLanguage();
        }
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(0);
        return collator;
    }

    private Calendar getLastModifiedDate(ListItem item) {
        if (item instanceof PageListItemV4Impl) {
            return ((PageListItemV4Impl)item).getPage().getLastModified();
        }
        return null;
    }

    @Nullable
    private ListItem toLinkListItem(@NotNull Resource itemResource) {
        Link link = this.linkHandler.get(itemResource).build();
        if (!link.isValid()) {
            return null;
        }
        String linkText = (String)itemResource.getValueMap().get("linkText", String.class);
        if (StringUtils.isBlank((CharSequence)linkText)) {
            linkText = link.getUrl();
        }
        if (link.getTargetPage() != null) {
            return this.newPageListItem(link.getTargetPage(), link, linkText);
        }
        return new LinkListItemV2Impl(linkText, new LinkWrapper(link), "item", this.getId(), this.getParentComponent(), this.resource);
    }

    protected Collection<ListItem> transformToPageListItems(Collection<Page> pages) {
        return pages.stream().filter(Objects::nonNull).map(page -> this.newPageListItem((Page)page, this.linkHandler.get(page).build(), null)).collect(Collectors.toList());
    }

    protected ListItem newPageListItem(@NotNull Page page, @NotNull Link link, @Nullable String linkText) {
        return new PageListItemV4Impl(page, link, this.getId(), this.getParentComponent(), this.showDescription(), this.linkItems() || this.displayItemAsTeaser(), linkText);
    }
}

