/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.core.components.impl.servlets;

import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.Rendition;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"wcm-io/wcm/core/components/image/v2/image"}, selectors={"imgwidth"}, extensions={"jpg", "png", "gif"}, methods={"GET"})
public class ImageWidthProxyServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private MimeTypeService mimeTypeService;
    public static final String SELECTOR = "imgwidth";
    private static final Logger log = LoggerFactory.getLogger(ImageWidthProxyServlet.class);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        long width = this.getWidth(request);
        Media media = this.buildMedia(request, width);
        if (!media.isValid()) {
            log.debug("Unable to resolve media: {}, width={}", (Object)media.getMediaRequest().getMediaRef(), (Object)width);
            response.sendError(404);
            return;
        }
        String url = media.getUrl();
        Rendition rendition = media.getRendition();
        if (this.usesImageFileServlet(url)) {
            log.debug("Forward to {}", (Object)url);
            request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        } else if (rendition != null) {
            log.debug("Stream binary content from {}", (Object)rendition.getPath());
            response.setContentType(this.getMimeType(request));
            Resource resource = (Resource)AdaptTo.notNull((Adaptable)rendition, Resource.class);
            try (InputStream is = (InputStream)resource.adaptTo(InputStream.class);){
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
            }
        }
    }

    private long getWidth(SlingHttpServletRequest request) {
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors.length >= 2) {
            return NumberUtils.toLong((String)selectors[1]);
        }
        return 0L;
    }

    private Media buildMedia(SlingHttpServletRequest request, long width) {
        Resource resource = request.getResource();
        MediaHandler mediaHandler = (MediaHandler)AdaptTo.notNull((Adaptable)request, MediaHandler.class);
        MediaBuilder builder = mediaHandler.get(resource);
        if (width > 0L) {
            builder.args(new MediaArgs().fixedWidth(width));
        }
        return builder.build();
    }

    private boolean usesImageFileServlet(@Nullable String mediaUrl) {
        return StringUtils.contains((CharSequence)mediaUrl, (CharSequence)".image_file.");
    }

    private String getMimeType(SlingHttpServletRequest request) {
        String mimeType = this.mimeTypeService.getMimeType(request.getRequestPathInfo().getExtension());
        return StringUtils.defaultString((String)mimeType, (String)"application/octet-stream");
    }
}

