/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.parsys.componentinfo.AllowedComponentsProvider;
import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import io.wcm.wcm.parsys.componentinfo.ParsysConfigManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AllowedComponentsProvider.class}, immediate=true)
public final class AllowedComponentsProviderImpl
implements AllowedComponentsProvider {
    @Reference
    private ParsysConfigManager parsysConfigManager;

    @Override
    @NotNull
    public Set<String> getAllowedComponents(@NotNull String resourcePath, @NotNull ResourceResolver resolver) {
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)resolver, PageManager.class);
        Page page = pageManager.getContainingPage(resourcePath);
        if (page == null && StringUtils.contains((CharSequence)resourcePath, (CharSequence)"/jcr:content")) {
            page = pageManager.getPage(StringUtils.substringBefore((String)resourcePath, (String)"/jcr:content"));
        }
        if (page == null) {
            return Collections.emptySet();
        }
        String relativePath = StringUtils.substringAfter((String)resourcePath, (String)(page.getPath() + "/"));
        return this.getAllowedComponents(page, relativePath, null, resolver);
    }

    @Override
    @NotNull
    public Set<String> getAllowedComponents(@NotNull Page page, @NotNull String relativeResourcePath, @Nullable String resourceType, @NotNull ResourceResolver resolver) {
        HashSet<String> allowedComponents = new HashSet<String>();
        HashSet<String> deniedComponents = new HashSet<String>();
        String pageComponentPath = page.getContentResource().getResourceType();
        Iterable<ParsysConfig> parSysConfigs = this.parsysConfigManager.getParsysConfigs(pageComponentPath, relativeResourcePath, resolver);
        Resource parentResource = null;
        Resource grandParentResource = null;
        for (ParsysConfig pathDef : parSysConfigs) {
            boolean includePathDef = false;
            if (pathDef.getAllowedParents().isEmpty()) {
                includePathDef = true;
            } else {
                String checkResourceType = null;
                if (pathDef.getParentAncestorLevel() == 1) {
                    if (resourceType != null) {
                        checkResourceType = resourceType;
                    } else if (parentResource == null && (parentResource = resolver.getResource(page.getPath() + "/" + relativeResourcePath)) != null) {
                        checkResourceType = parentResource.getResourceType();
                    }
                } else if (pathDef.getParentAncestorLevel() == 2) {
                    if (grandParentResource == null) {
                        grandParentResource = resolver.getResource(page.getPath() + "/" + relativeResourcePath + "/..");
                    }
                    if (grandParentResource != null) {
                        checkResourceType = grandParentResource.getResourceType();
                    }
                }
                if (checkResourceType != null) {
                    includePathDef = pathDef.getAllowedParents().contains(checkResourceType);
                }
            }
            if (!includePathDef) continue;
            allowedComponents.addAll(pathDef.getAllowedChildren());
            deniedComponents.addAll(pathDef.getDeniedChildren());
        }
        allowedComponents.removeAll(deniedComponents);
        return allowedComponents;
    }

    @Override
    @NotNull
    public Set<String> getAllowedComponentsForTemplate(@NotNull String pageComponentPath, @NotNull ResourceResolver resolver) {
        Resource pageComponentResource = resolver.getResource(pageComponentPath);
        if (pageComponentResource != null) {
            Iterable<ParsysConfig> parSysConfigs = this.parsysConfigManager.getParsysConfigs(pageComponentResource.getPath(), resolver);
            TreeSet<String> allowedChildren = new TreeSet<String>();
            for (ParsysConfig parSysConfig : parSysConfigs) {
                allowedChildren.addAll(parSysConfig.getAllowedChildren());
            }
            return allowedChildren;
        }
        return Collections.emptySet();
    }
}

