/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ParsysConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint={pageComponentPath}"})
@Designate(ocd=Config.class, factory=true)
public final class OsgiParsysConfigProvider
implements ParsysConfig {
    private static final Logger log = LoggerFactory.getLogger(OsgiParsysConfigProvider.class);
    static final int DEFAULT_PARENT_ANCESTOR_LEVEL = 1;
    private String pageComponentPath;
    private Pattern pathPattern;
    private int parentAncestorLevel;
    private Set<String> allowedParents;
    private Set<String> allowedChildren;
    private Set<String> deniedChildren;
    private boolean inherit;

    @Override
    @NotNull
    public String getPageComponentPath() {
        return this.pageComponentPath;
    }

    @Override
    public Pattern getPathPattern() {
        return this.pathPattern;
    }

    @Override
    public int getParentAncestorLevel() {
        return this.parentAncestorLevel;
    }

    @Override
    @NotNull
    public Set<String> getAllowedParents() {
        return this.allowedParents;
    }

    @Override
    @NotNull
    public Set<String> getAllowedChildren() {
        return this.allowedChildren;
    }

    @Override
    @NotNull
    public Set<String> getDeniedChildren() {
        return this.deniedChildren;
    }

    @Override
    public boolean isInherit() {
        return this.inherit;
    }

    @Activate
    private void activate(Config config) {
        this.pageComponentPath = config.pageComponentPath();
        this.parentAncestorLevel = config.parentAncestorLevel();
        String pathPatternString = config.pathPattern();
        Object path = config.path();
        if (StringUtils.isNotEmpty((CharSequence)pathPatternString)) {
            this.pathPattern = Pattern.compile(pathPatternString);
        } else if (StringUtils.isNotBlank((CharSequence)path)) {
            if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"jcr:content/")) {
                path = "jcr:content/" + (String)path;
            }
            this.pathPattern = Pattern.compile("^" + Pattern.quote((String)path) + "$");
        }
        HashSet<String> allowedChildrenSet = new HashSet<String>();
        if (config.allowedChildren() != null) {
            for (String resourceType : config.allowedChildren()) {
                if (!StringUtils.isNotBlank((CharSequence)resourceType)) continue;
                allowedChildrenSet.add(resourceType);
            }
        }
        this.allowedChildren = Collections.unmodifiableSet(allowedChildrenSet);
        HashSet<String> deniedChildrenSet = new HashSet<String>();
        if (config.deniedChildren() != null) {
            for (String resourceType : config.deniedChildren()) {
                if (!StringUtils.isNotBlank((CharSequence)resourceType)) continue;
                deniedChildrenSet.add(resourceType);
            }
        }
        this.deniedChildren = Collections.unmodifiableSet(deniedChildrenSet);
        HashSet<String> allowedParentsSet = new HashSet<String>();
        if (config.allowedParents() != null) {
            for (String resourceType : config.allowedParents()) {
                if (!StringUtils.isNotBlank((CharSequence)resourceType)) continue;
                allowedParentsSet.add(resourceType);
            }
        }
        this.allowedParents = Collections.unmodifiableSet(allowedParentsSet);
        this.inherit = config.inherit();
        if (log.isDebugEnabled()) {
            log.debug("{}: pageComponentPath={}, path={}, pathPattern={}, allowedChildren={}, deniedChildren={}, allowedParents={}, parentAncestorLevel={},inherit={}", new Object[]{this.getClass().getSimpleName(), this.pageComponentPath, path, this.pathPattern, this.allowedChildren, this.deniedChildren, this.allowedParents, this.parentAncestorLevel, this.inherit});
        }
        if (StringUtils.isBlank((CharSequence)this.pageComponentPath)) {
            log.warn("pageComponentPath cannot be null or empty. This configuration will be ignored.");
        }
        if (this.pathPattern == null) {
            log.warn("Path pattern cannot be null. Please set the property pathPattern or path.");
        }
    }

    @ObjectClassDefinition(name="wcm.io Paragraph System Configuration Extension", description="Extends configurations of allowed components for wcm.io paragraph systems.")
    static @interface Config {
        @AttributeDefinition(name="Page Component Path", description="Resource type of the page component for this parsys config (required).", required=true)
        public String pageComponentPath();

        @AttributeDefinition(name="Path", description="Parsys node name (e.g. 'content') or parsys path relative to page (should start with 'jcr:content/'). Path will be ignored if a pattern is defined.")
        public String path();

        @AttributeDefinition(name="Path Pattern", description="Regular expression that matches parsys path within the page, e.g. '^jcr:content/.*$'. Leave empty if you want to use the Path property.")
        public String pathPattern();

        @AttributeDefinition(name="Allowed Children", description="Resource types of the allowed components in this paragraph system")
        public String[] allowedChildren();

        @AttributeDefinition(name="Denied Children", description="Resource types of the denied components in this paragraph system")
        public String[] deniedChildren();

        @AttributeDefinition(name="Allowed Parents", description="(optional) Resource types of parsys parent components. You can limit the context of parsys where child components can be added by configuratiion of allowed parent components.")
        public String[] allowedParents();

        @AttributeDefinition(name="Parent Ancestor Level", description="(optional) Indicates the ancestor level, where allowed parents should match.", options={@Option(value="1", label="Direct Parent (1)"), @Option(value="2", label="Grand Parent (2)")})
        public int parentAncestorLevel() default 1;

        @AttributeDefinition(name="Inherit", description="Inherit paragraph system configurations from super resource types.")
        public boolean inherit() default true;
    }
}

