/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.commons.request.RequestParam;
import io.wcm.sling.commons.resource.ResourceType;
import io.wcm.wcm.commons.contenttype.ContentType;
import io.wcm.wcm.commons.instancetype.InstanceTypeService;
import io.wcm.wcm.parsys.componentinfo.AllowedComponentsProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=wcmio-parsys-components", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET"})
public final class ParsysComponentsServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String RP_PATH = "path";
    static final String RP_RESOURCE_TYPE = "resourceType";
    static final String SELECTOR = "wcmio-parsys-components";
    private static final Logger log = LoggerFactory.getLogger(ParsysComponentsServlet.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Reference
    private AllowedComponentsProvider allowedComponentsProvider;
    @Reference
    private InstanceTypeService instanceTypeService;
    private boolean enabled;

    @Activate
    protected void activate() {
        this.enabled = this.instanceTypeService.isAuthor();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.enabled) {
            response.sendError(404);
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)resolver, PageManager.class);
        Page currentPage = pageManager.getContainingPage(request.getResource());
        if (currentPage == null) {
            response.sendError(404);
            return;
        }
        long startTime = 0L;
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        response.setContentType(ContentType.JSON);
        SequencedCollection<Object> allowedComponents = Collections.emptyList();
        String relativePath = RequestParam.get((ServletRequest)request, (String)RP_PATH);
        String resourceType = RequestParam.get((ServletRequest)request, (String)RP_RESOURCE_TYPE);
        if (StringUtils.isNotEmpty((CharSequence)relativePath)) {
            Set<String> allowed = this.allowedComponentsProvider.getAllowedComponents(currentPage, relativePath, resourceType, resolver);
            TreeSet<String> allowedComponentsRelative = new TreeSet<String>();
            for (String allowedResourceType : allowed) {
                allowedComponentsRelative.add(ResourceType.makeAbsolute((String)allowedResourceType, (ResourceResolver)resolver));
            }
            allowedComponents = allowedComponentsRelative;
        }
        response.getWriter().write(OBJECT_MAPPER.writeValueAsString(allowedComponents));
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            log.debug("ParsysComponentsServlet for {}/{} took {}ms", new Object[]{currentPage.getPath(), relativePath, duration});
        }
    }
}

