/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.componentinfo.impl;

import io.wcm.sling.commons.resource.ResourceType;
import io.wcm.wcm.parsys.componentinfo.ParsysConfig;
import io.wcm.wcm.parsys.componentinfo.ParsysConfigManager;
import io.wcm.wcm.parsys.componentinfo.impl.ResourceParsysConfigProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ParsysConfigManager.class}, immediate=true, reference={@Reference(service=ParsysConfig.class, name="parsysConfig", bind="bindParsysConfig", unbind="unbindParsysConfig", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public final class ParsysConfigManagerImpl
implements ParsysConfigManager {
    private final RankedServices<ParsysConfig> osgiParsysConfigs = new RankedServices(Order.ASCENDING);

    @Override
    @NotNull
    public Iterable<ParsysConfig> getParsysConfigs(@NotNull String pageComponentPath, @NotNull ResourceResolver resolver) {
        Resource pageComponentResource = resolver.getResource(pageComponentPath);
        if (pageComponentResource != null) {
            return Collections.unmodifiableCollection(this.getParsysConfigsWithInheritance(pageComponentResource, resolver));
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Iterable<ParsysConfig> getParsysConfigs(@NotNull String pageComponentPath, @NotNull String relativePath, @NotNull ResourceResolver resolver) {
        Iterable<ParsysConfig> configs = this.getParsysConfigs(pageComponentPath, resolver);
        return IterableUtils.filteredIterable(configs, parsysConfig -> {
            if (parsysConfig == null || parsysConfig.getPathPattern() == null) {
                return false;
            }
            Pattern pathPattern = parsysConfig.getPathPattern();
            if (pathPattern == null) {
                return false;
            }
            return pathPattern.matcher(relativePath).matches();
        });
    }

    private Collection<ParsysConfig> getParsysConfigs(Resource pageComponentResource) {
        ArrayList<ParsysConfig> configs = new ArrayList<ParsysConfig>();
        ResourceParsysConfigProvider resourceParsysConfigProvider = new ResourceParsysConfigProvider(pageComponentResource);
        configs.addAll(resourceParsysConfigProvider.getPathDefs());
        for (ParsysConfig osgiParsysConfig : this.osgiParsysConfigs) {
            if (!ResourceType.equals((String)pageComponentResource.getPath(), (String)osgiParsysConfig.getPageComponentPath(), (ResourceResolver)pageComponentResource.getResourceResolver())) continue;
            configs.add(osgiParsysConfig);
        }
        return configs;
    }

    private Collection<ParsysConfig> getParsysConfigsWithInheritance(Resource pageComponentResource, ResourceResolver resolver) {
        Resource superResource;
        ArrayList<ParsysConfig> configs = new ArrayList<ParsysConfig>();
        configs.addAll(this.getParsysConfigs(pageComponentResource));
        String resourceSuperType = pageComponentResource.getResourceSuperType();
        if (StringUtils.isNotEmpty((CharSequence)resourceSuperType) && (superResource = resolver.getResource(resourceSuperType)) != null) {
            Collection<ParsysConfig> configsFromSupertype = this.getParsysConfigsWithInheritance(superResource, resolver);
            ArrayList<ParsysConfig> inheritedConfigs = new ArrayList<ParsysConfig>();
            for (ParsysConfig configFromSupertype : configsFromSupertype) {
                if (!this.existingPathParentConfigAllowsInheritance(configFromSupertype, configs)) continue;
                inheritedConfigs.add(configFromSupertype);
            }
            configs.addAll(inheritedConfigs);
        }
        return configs;
    }

    private boolean existingPathParentConfigAllowsInheritance(ParsysConfig item, List<ParsysConfig> existingItems) {
        for (ParsysConfig existingItem : existingItems) {
            if (!this.matchesPathParent(item, existingItem) || existingItem.isInherit()) continue;
            return false;
        }
        return true;
    }

    private boolean matchesPathParent(ParsysConfig item1, ParsysConfig item2) {
        Pattern pattern1 = item1.getPathPattern();
        Pattern pattern2 = item2.getPathPattern();
        String pathPattern1 = pattern1 != null ? pattern1.pattern() : "";
        String pathPattern2 = pattern2 != null ? pattern2.pattern() : "";
        return pathPattern1.equals(pathPattern2) && item1.getParentAncestorLevel() == item2.getParentAncestorLevel() && item1.getAllowedParents().equals(item2.getAllowedParents());
    }

    void bindParsysConfig(ParsysConfig service, Map<String, Object> props) {
        this.osgiParsysConfigs.bind((Object)service, props);
    }

    void unbindParsysConfig(ParsysConfig service, Map<String, Object> props) {
        this.osgiParsysConfigs.unbind((Object)service, props);
    }
}

