/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.parsys.controller;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.component.ComponentPropertyResolution;
import io.wcm.wcm.commons.component.ComponentPropertyResolver;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import io.wcm.wcm.parsys.ParsysItem;
import io.wcm.wcm.parsys.controller.CssBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Parsys.class, ContainerExporter.class, ComponentExporter.class}, resourceType={"wcm-io/wcm/parsys/components/parsys"})
@Exporter(name="jackson", extensions={"json"})
@ProviderType
public final class Parsys
implements ContainerExporter {
    static final String RESOURCE_TYPE = "wcm-io/wcm/parsys/components/parsys";
    static final String RA_PARSYS_PARENT_RESOURCE = "parsysParentResource";
    static final String SECTION_DEFAULT_CLASS_NAME = "section";
    static final String NEWAREA_RESOURCE_PATH = "./*";
    static final String NEWAREA_STYLE = "clear:both";
    static final String NEWAREA_CSS_CLASS_NAME = "new";
    static final String NEWAREA_CHILD_NAME = "newpar";
    static final String FALLBACK_NEWAREA_RESOURCE_TYPE = "wcm-io/wcm/parsys/components/parsys/newpar";
    static final String DEFAULT_ELEMENT_NAME = "div";
    @RequestAttribute(name="parsysParentResource", injectionStrategy=InjectionStrategy.OPTIONAL)
    private Resource parsysParentResource;
    @SlingObject
    private SlingHttpServletRequest request;
    @SlingObject
    private Resource currentResource;
    @SlingObject
    private ResourceResolver resolver;
    @AemObject
    private WCMMode wcmMode;
    @AemObject
    private ComponentContext componentContext;
    @OSGiService
    private ModelFactory modelFactory;
    @OSGiService
    private ComponentPropertyResolverFactory componentPropertyResolverFactory;
    @OSGiService
    private SlingModelFilter slingModelFilter;
    private ComponentManager componentManager;
    private boolean generateDefaultCss;
    private String paragraphCss;
    private String newAreaCss;
    private String paragraphElementName;
    private boolean paragraphDecoration;
    private boolean paragraphValidate;
    private String wrapperElementName;
    private String wrapperCss;
    private List<Item> items;
    private Map<String, ? extends ComponentExporter> childModels;
    private String[] exportedItemsOrder;

    @PostConstruct
    private void activate() {
        try (ComponentPropertyResolver componentPropertyResolver = this.componentPropertyResolverFactory.get(this.componentContext).componentPropertiesResolution(ComponentPropertyResolution.RESOLVE_INHERIT);){
            this.generateDefaultCss = (Boolean)componentPropertyResolver.get("wcmio:parsysGenerateDefaultCss", (Object)true);
            this.paragraphCss = (String)componentPropertyResolver.get("wcmio:parsysParagraphCss", String.class);
            this.newAreaCss = (String)componentPropertyResolver.get("wcmio:parsysNewAreaCss", String.class);
            this.paragraphElementName = (String)componentPropertyResolver.get("wcmio:parsysParagraphElement", String.class);
            this.wrapperElementName = (String)componentPropertyResolver.get("wcmio:parsysWrapperElement", String.class);
            this.wrapperCss = (String)componentPropertyResolver.get("wcmio:parsysWrapperCss", String.class);
            this.paragraphValidate = (Boolean)componentPropertyResolver.get("wcmio:parsysParagraphValidate", (Object)false);
            String[] paragraphNoDecorationWcmMode = (String[])componentPropertyResolver.get("wcmio:parsysParagraphNoDecorationWcmMode", String[].class);
            this.paragraphDecoration = Parsys.getDecoration(paragraphNoDecorationWcmMode, this.wcmMode);
        }
        this.items = new ArrayList<Item>();
        if (this.parsysParentResource == null) {
            this.parsysParentResource = this.currentResource;
        }
        for (Resource childResource : this.parsysParentResource.getChildren()) {
            if (!Parsys.acceptResource(childResource)) continue;
            Item item = this.createResourceItem(childResource);
            if (this.wcmMode == WCMMode.DISABLED && !item.isValid()) continue;
            this.items.add(item);
        }
        if (this.wcmMode != WCMMode.DISABLED) {
            this.items.add(this.createNewAreaItem());
        }
    }

    private static boolean acceptResource(Resource resource) {
        return !StringUtils.equals((CharSequence)resource.getResourceType(), (CharSequence)"nt:unstructured");
    }

    private static boolean getDecoration(String[] paragraphNoDecorationWcmMode, WCMMode wcmMode) {
        if (paragraphNoDecorationWcmMode != null && paragraphNoDecorationWcmMode.length > 0) {
            for (String wcmModeItem : paragraphNoDecorationWcmMode) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)wcmMode.name(), (CharSequence)wcmModeItem)) continue;
                return false;
            }
        }
        return true;
    }

    private Item createResourceItem(Resource resource) {
        Optional<Boolean> validStatus;
        CssBuilder css = new CssBuilder();
        if (this.generateDefaultCss) {
            css.add(SECTION_DEFAULT_CLASS_NAME);
        }
        css.add(this.paragraphCss);
        Map<String, String> htmlTagAttrs = this.getComponentHtmlTagAttributes(resource.getResourceType());
        String itemElementName = this.paragraphElementName;
        if (StringUtils.isEmpty((CharSequence)itemElementName)) {
            itemElementName = StringUtils.defaultString((String)htmlTagAttrs.get("cq:tagName"), (String)DEFAULT_ELEMENT_NAME);
        }
        if (StringUtils.isEmpty((CharSequence)this.paragraphCss)) {
            css.add(htmlTagAttrs.get("class"));
        }
        boolean valid = true;
        if (this.paragraphValidate && (validStatus = this.isParagraphValid(resource)).isPresent()) {
            valid = validStatus.get();
        }
        return new Item(resource.getPath()).elementName(itemElementName).cssClassName(css.build()).decorate(this.paragraphDecoration).valid(valid);
    }

    private Optional<@NotNull Boolean> isParagraphValid(Resource resource) {
        ParsysItem parsysItem = (ParsysItem)this.modelFactory.getModelFromWrappedRequest(this.request, resource, ParsysItem.class);
        if (parsysItem != null) {
            return Optional.of(parsysItem.isValid());
        }
        try {
            Object model = this.modelFactory.getModelFromResource(resource);
            if (model instanceof ParsysItem) {
                return Optional.of(((ParsysItem)model).isValid());
            }
        }
        catch (ModelClassException modelClassException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private Map<String, String> getComponentHtmlTagAttributes(String resourceType) {
        Component component;
        if (StringUtils.isNotEmpty((CharSequence)resourceType) && (component = this.componentManager().getComponent(resourceType)) != null && component.getHtmlTagAttributes() != null) {
            return component.getHtmlTagAttributes();
        }
        return Collections.emptyMap();
    }

    private ComponentManager componentManager() {
        if (this.componentManager == null) {
            this.componentManager = (ComponentManager)AdaptTo.notNull((Adaptable)this.resolver, ComponentManager.class);
        }
        return this.componentManager;
    }

    private Item createNewAreaItem() {
        String style = null;
        CssBuilder css = new CssBuilder();
        css.add(NEWAREA_CSS_CLASS_NAME);
        if (this.generateDefaultCss) {
            style = NEWAREA_STYLE;
            css.add(SECTION_DEFAULT_CLASS_NAME);
        }
        css.add(this.newAreaCss);
        String newAreaElementName = StringUtils.defaultString((String)this.paragraphElementName, (String)DEFAULT_ELEMENT_NAME);
        String newAreaResourceType = this.getNewAreaResourceType(this.componentContext.getComponent().getPath());
        return new Item(NEWAREA_RESOURCE_PATH).newArea(true).resourceType(newAreaResourceType).elementName(newAreaElementName).style(style).cssClassName(css.build()).decorate(true);
    }

    private String getNewAreaResourceType(String componentPath) {
        Resource componentResource = this.resolver.getResource(componentPath);
        if (componentResource != null) {
            if (componentResource.getChild(NEWAREA_CHILD_NAME) != null) {
                return componentPath + "/newpar";
            }
            String resourceSuperType = componentResource.getResourceSuperType();
            if (StringUtils.isNotEmpty((CharSequence)resourceSuperType)) {
                return this.getNewAreaResourceType(resourceSuperType);
            }
        }
        return FALLBACK_NEWAREA_RESOURCE_TYPE;
    }

    @JsonIgnore
    public List<Item> getItems() {
        return this.items;
    }

    @JsonIgnore
    public String getWrapperElementName() {
        return StringUtils.defaultString((String)this.wrapperElementName, (String)DEFAULT_ELEMENT_NAME);
    }

    @JsonIgnore
    public String getWrapperCss() {
        return this.wrapperCss;
    }

    @JsonIgnore
    public boolean isWrapperElement() {
        return StringUtils.isNotBlank((CharSequence)this.wrapperElementName);
    }

    @NotNull
    public String getExportedType() {
        return this.currentResource.getResourceType();
    }

    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.childModels == null) {
            this.childModels = this.getChildModels(ComponentExporter.class);
        }
        return this.childModels;
    }

    public String @NotNull [] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            Map<String, ? extends ComponentExporter> models = this.getExportedItems();
            this.exportedItemsOrder = !models.isEmpty() ? models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    private <T> Map<String, T> getChildModels(@NotNull Class<T> modelClass) {
        LinkedHashMap<String, Object> models = new LinkedHashMap<String, Object>();
        for (Resource child : this.slingModelFilter.filterChildResources(this.currentResource.getChildren())) {
            Object model;
            if (!Parsys.acceptResource(child) || (model = this.modelFactory.getModelFromWrappedRequest(this.request, child, modelClass)) == null) continue;
            models.put(child.getName(), model);
        }
        return models;
    }

    public static final class Item {
        private final String resourcePath;
        private String resourceType;
        private String elementName;
        private String style;
        private String cssClassName;
        private boolean decorate;
        private boolean newArea;
        private boolean valid;

        Item(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        Item resourceType(String value) {
            this.resourceType = value;
            return this;
        }

        Item elementName(String value) {
            this.elementName = value;
            return this;
        }

        Item style(String value) {
            this.style = value;
            return this;
        }

        Item cssClassName(String value) {
            this.cssClassName = value;
            return this;
        }

        Item decorate(boolean value) {
            this.decorate = value;
            return this;
        }

        Item newArea(boolean value) {
            this.newArea = value;
            return this;
        }

        Item valid(boolean value) {
            this.valid = value;
            return this;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getStyle() {
            return this.style;
        }

        public String getCssClassName() {
            return this.cssClassName;
        }

        public boolean isDecorate() {
            return this.decorate;
        }

        public boolean isNewArea() {
            return this.newArea;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

