/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.clientlibs.components;

import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IncludeUtil {
    private IncludeUtil() {
    }

    @Nullable
    public static String[] toCategoryArray(Object categories) {
        String[] categoryArray = null;
        if (categories instanceof String) {
            categoryArray = new String[]{(String)categories};
        } else if (categories != null && categories.getClass().isArray()) {
            categoryArray = new String[Array.getLength(categories)];
            for (int i = 0; i < Array.getLength(categories); ++i) {
                Object value = Array.get(categories, i);
                if (value == null) {
                    value = "";
                }
                categoryArray[i] = value.toString();
            }
        }
        return categoryArray;
    }

    @NotNull
    public static List<String> getLibraryUrls(@NotNull HtmlLibraryManager htmlLibraryManager, @NotNull ResourceResolver resourceResolver, @NotNull String[] categoryArray, @NotNull LibraryType libraryType) {
        return htmlLibraryManager.getLibraries(categoryArray, libraryType, false, true).stream().map(library -> IncludeUtil.getLibraryUrl(resourceResolver, library, libraryType, htmlLibraryManager.isMinifyEnabled())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static String getLibraryUrl(@NotNull ResourceResolver resourceResolver, @NotNull ClientLibrary library, @NotNull LibraryType libraryType, boolean minify) {
        String path = library.getIncludePath(libraryType, minify);
        if (library.allowProxy() && (path.startsWith("/libs/") || path.startsWith("/apps/"))) {
            path = "/etc.clientlibs" + path.substring(5);
        } else if (resourceResolver.getResource(library.getPath()) == null) {
            path = null;
        }
        return path;
    }
}

