/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.clientlibs.components;

import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import io.wcm.wcm.ui.clientlibs.components.IncludeUtil;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.xss.XSSAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class CSSInclude {
    @SlingObject
    private ResourceResolver resourceResolver;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    private XSSAPI xssApi;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object categories;
    private String include;

    @PostConstruct
    private void activate() {
        List<String> libraryPaths;
        String[] categoryArray = IncludeUtil.toCategoryArray(this.categories);
        if (categoryArray != null && !(libraryPaths = IncludeUtil.getLibraryUrls(this.htmlLibraryManager, this.resourceResolver, categoryArray, LibraryType.CSS)).isEmpty()) {
            this.include = this.buildIncludeString(libraryPaths);
        }
    }

    @NotNull
    private String buildIncludeString(@NotNull List<String> libraryPaths) {
        StringBuilder markup = new StringBuilder();
        for (String libraryPath : libraryPaths) {
            markup.append("<link rel=\"stylesheet\" href=\"" + this.xssApi.encodeForHTMLAttr(libraryPath) + "\" type=\"text/css\">\n");
        }
        return markup.toString();
    }

    @Nullable
    public String getInclude() {
        return this.include;
    }
}

