/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.clientlibs.components;

import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import io.wcm.wcm.ui.clientlibs.components.IncludeUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.xss.XSSAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class JSInclude {
    private static final Set CROSSORIGIN_ALLOWED_VALUES = new HashSet<String>(Arrays.asList("anonymous", "use-credentials"));
    private static final Set REFERRERPOLICY_ALLOWED_VALUES = new HashSet<String>(Arrays.asList("no-referrer", "no-referrer-when-downgrade", "origin", "origin-when-cross-origin", "same-origin", "strict-origin", "strict-origin-when-cross-origin", "unsafe-url"));
    private static final Set TYPE_ALLOWED_VALUES = new HashSet<String>(Arrays.asList("text/javascript", "module"));
    @SlingObject
    private ResourceResolver resourceResolver;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    private XSSAPI xssApi;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object categories;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean async;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String crossorigin;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean defer;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String integrity;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean nomodule;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String nonce;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String referrerpolicy;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String type;
    private String include;

    @PostConstruct
    private void activate() {
        List<String> libraryPaths;
        String[] categoryArray = IncludeUtil.toCategoryArray(this.categories);
        if (categoryArray != null && !(libraryPaths = IncludeUtil.getLibraryUrls(this.htmlLibraryManager, this.resourceResolver, categoryArray, LibraryType.JS)).isEmpty()) {
            Map<String, String> attrs = this.validateAndBuildAttributes();
            this.include = this.buildIncludeString(libraryPaths, attrs);
        }
    }

    @NotNull
    private Map<String, String> validateAndBuildAttributes() {
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        if (this.async) {
            attrs.put("async", null);
        }
        if (CROSSORIGIN_ALLOWED_VALUES.contains(this.crossorigin)) {
            attrs.put("crossorigin", this.crossorigin);
        }
        if (this.defer) {
            attrs.put("defer", null);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.integrity)) {
            attrs.put("integrity", this.xssApi.encodeForHTMLAttr(this.integrity));
        }
        if (this.nomodule) {
            attrs.put("nomodule", null);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.nonce)) {
            attrs.put("nonce", this.xssApi.encodeForHTMLAttr(this.nonce));
        }
        if (REFERRERPOLICY_ALLOWED_VALUES.contains(this.referrerpolicy)) {
            attrs.put("referrerpolicy", this.referrerpolicy);
        }
        if (TYPE_ALLOWED_VALUES.contains(this.type)) {
            attrs.put("type", this.type);
        }
        return attrs;
    }

    @NotNull
    private String buildIncludeString(@NotNull List<String> libraryPaths, @NotNull Map<String, String> attrs) {
        StringBuilder markup = new StringBuilder();
        for (String libraryPath : libraryPaths) {
            markup.append("<script src=\"" + this.xssApi.encodeForHTMLAttr(libraryPath) + "\"");
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                markup.append(" ");
                markup.append(attr.getKey());
                if (attr.getValue() == null) continue;
                markup.append("=\"");
                markup.append(attr.getValue());
                markup.append("\"");
            }
            markup.append("></script>\n");
        }
        return markup.toString();
    }

    @Nullable
    public String getInclude() {
        return this.include;
    }
}

