/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.util;

import com.adobe.granite.ui.components.ComponentHelper;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.day.text.Text;
import io.wcm.wcm.ui.granite.util.RootPathDetector;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class RootPathResolver {
    static final String PN_ROOT_PATH = "rootPath";
    static final String PN_APPEND_PATH = "appendPath";
    static final String PN_FALLBACK_PATH = "fallbackRootPath";
    static final String DEFAULT_FALLBACK_ROOT_PATH = "/";
    private final ComponentHelper cmp;
    private final Config cfg;
    private final ExpressionHelper ex;
    private final SlingHttpServletRequest request;
    private final ResourceResolver resourceResolver;
    private RootPathDetector rootPathDetector;
    private String fallbackRootPath = "/";

    public RootPathResolver(@NotNull ComponentHelper cmp, @NotNull SlingHttpServletRequest request) {
        this.cmp = cmp;
        this.cfg = cmp.getConfig();
        this.ex = cmp.getExpressionHelper();
        this.request = request;
        this.resourceResolver = request.getResourceResolver();
    }

    public void setRootPathDetector(@NotNull RootPathDetector rootPathDetector) {
        this.rootPathDetector = rootPathDetector;
    }

    public void setFallbackRootPath(@NotNull String fallbackRootPath) {
        this.fallbackRootPath = fallbackRootPath;
    }

    @NotNull
    public String get() {
        String rootPath = this.getRootPath();
        rootPath = this.appendPath(rootPath);
        return this.getExistingPath(rootPath);
    }

    public Map<String, Object> getOverrideProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PN_ROOT_PATH, this.get());
        props.put(PN_APPEND_PATH, "");
        props.put(PN_FALLBACK_PATH, "");
        return props;
    }

    @NotNull
    private String getRootPath() {
        String rootPath = this.ex.getString((String)this.cfg.get(PN_ROOT_PATH, String.class));
        if (StringUtils.isNotBlank((CharSequence)rootPath)) {
            return rootPath;
        }
        if (this.rootPathDetector != null && (rootPath = this.rootPathDetector.detectRootPath(this.cmp, this.request)) != null && StringUtils.isNotBlank((CharSequence)rootPath)) {
            return rootPath;
        }
        rootPath = this.ex.getString((String)this.cfg.get(PN_FALLBACK_PATH, String.class));
        if (StringUtils.isNotBlank((CharSequence)rootPath)) {
            return rootPath;
        }
        return this.fallbackRootPath;
    }

    @NotNull
    private String appendPath(@NotNull String rootPath) {
        String appendPath = this.ex.getString((String)this.cfg.get(PN_APPEND_PATH, String.class));
        if (StringUtils.isBlank((CharSequence)appendPath)) {
            return rootPath;
        }
        StringBuilder combinedPath = new StringBuilder(rootPath);
        if (!StringUtils.startsWith((CharSequence)appendPath, (CharSequence)DEFAULT_FALLBACK_ROOT_PATH)) {
            combinedPath.append(DEFAULT_FALLBACK_ROOT_PATH);
        }
        combinedPath.append(appendPath);
        return combinedPath.toString();
    }

    @NotNull
    String getExistingPath(@NotNull String rootPath) {
        if (this.resourceResolver.getResource(rootPath) == null) {
            String parentPath = Text.getRelativeParent((String)rootPath, (int)1);
            if (StringUtils.isBlank((CharSequence)parentPath)) {
                return DEFAULT_FALLBACK_ROOT_PATH;
            }
            return this.getExistingPath(parentPath);
        }
        return rootPath;
    }
}

