/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.components.pathfield;

import com.adobe.granite.ui.components.ComponentHelper;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ds.DataSource;
import com.google.common.collect.ImmutableMap;
import io.wcm.wcm.ui.granite.components.pathfield.Column;
import io.wcm.wcm.ui.granite.components.pathfield.ColumnItem;
import io.wcm.wcm.ui.granite.pathfield.impl.util.DummyPageContext;
import io.wcm.wcm.ui.granite.resource.GraniteUiSyntheticResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public final class ColumnView {
    private static final String FALLBACK_ROOT_RESOURCE = "/";
    @SlingObject
    private SlingHttpServletRequest request;
    @SlingObject
    private SlingHttpServletResponse response;
    @SlingObject
    private ResourceResolver resourceResolver;
    private Resource currentResource;
    private final List<Column> columns = new ArrayList<Column>();

    @PostConstruct
    private void activate() {
        ComponentHelper cmp = new ComponentHelper((PageContext)new DummyPageContext(this.request, this.response));
        Config cfg = cmp.getConfig();
        ExpressionHelper ex = cmp.getExpressionHelper();
        Integer size = (Integer)ex.get((String)cfg.get("size", String.class), Integer.class);
        String itemResourceType = cfg.get("itemResourceType");
        boolean showRoot = (Boolean)cfg.get("showRoot", (Object)false);
        boolean loadAncestors = (Boolean)cfg.get("loadAncestors", (Object)false);
        Resource rootResource = this.resourceResolver.getResource(ex.getString((String)cfg.get("rootPath", (Object)FALLBACK_ROOT_RESOURCE)));
        if (rootResource == null) {
            rootResource = this.resourceResolver.getResource(FALLBACK_ROOT_RESOURCE);
        }
        String path = ex.getString((String)cfg.get("path", (Object)rootResource.getPath()));
        this.currentResource = this.resourceResolver.getResource(path);
        if (this.currentResource == null || !this.isSameResourceOrChild(rootResource, this.currentResource)) {
            this.currentResource = rootResource;
        }
        if (showRoot && (StringUtils.equals((CharSequence)this.currentResource.getPath(), (CharSequence)rootResource.getPath()) || loadAncestors)) {
            this.columns.add(ColumnView.getRootColumn(rootResource, itemResourceType));
        }
        if (loadAncestors) {
            this.columns.addAll(ColumnView.getAncestorColumns(this.currentResource, rootResource));
        }
        DataSource dataSource = this.getDataSource(cmp, this.currentResource);
        this.columns.add(ColumnView.getCurrentResourceColumn(dataSource, size, this.currentResource, itemResourceType));
    }

    private boolean isSameResourceOrChild(Resource rootResource, Resource resource) {
        if (StringUtils.equals((CharSequence)rootResource.getPath(), (CharSequence)resource.getPath())) {
            return true;
        }
        return StringUtils.startsWith((CharSequence)resource.getPath(), (CharSequence)(rootResource.getPath() + FALLBACK_ROOT_RESOURCE));
    }

    public Resource getCurrentResource() {
        return this.currentResource;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    private DataSource getDataSource(ComponentHelper cmp, Resource resource) {
        try {
            ValueMapDecorator overwriteProperties = new ValueMapDecorator((Map)ImmutableMap.of((Object)"path", (Object)resource.getPath()));
            Resource dataSourceResourceWrapper = GraniteUiSyntheticResource.wrapMerge(this.request.getResource(), (ValueMap)overwriteProperties);
            return cmp.getItemDataSource(dataSourceResourceWrapper);
        }
        catch (IOException | ServletException ex) {
            throw new RuntimeException("Unable to get data source.", ex);
        }
    }

    private static Column getCurrentResourceColumn(DataSource dataSource, Integer size, Resource currentResource, String itemResourceType) {
        Iterator items = dataSource.iterator();
        boolean hasMore = false;
        if (size != null) {
            ArrayList<Resource> list = new ArrayList<Resource>();
            while (items.hasNext() && list.size() < size) {
                list.add((Resource)items.next());
            }
            hasMore = items.hasNext();
            items = list.iterator();
        }
        Column column = new Column().columnId(currentResource.getPath()).hasMore(hasMore).metaElement(true);
        while (items.hasNext()) {
            Resource item = (Resource)items.next();
            column.addItem(new ColumnItem(item).resourceType(itemResourceType));
        }
        return column;
    }

    private static Column getRootColumn(Resource rootResource, String itemResourceType) {
        String columnId = "parentof:" + rootResource.getPath();
        Column column = new Column().columnId(columnId).hasMore(false);
        column.addItem(new ColumnItem(rootResource).resourceType(itemResourceType).active(true));
        return column;
    }

    private static List<Column> getAncestorColumns(Resource currentResource, Resource rootResource) {
        ArrayList<Column> columns = new ArrayList<Column>();
        List<Resource> ancestors = ColumnView.getAncestors(currentResource, rootResource);
        for (int i = 0; i < ancestors.size(); ++i) {
            Resource r = ancestors.get(i);
            String activeId = i < ancestors.size() - 1 ? ancestors.get(i + 1).getPath() : currentResource.getPath();
            Column column = new Column().columnId(r.getPath()).lazy(true).activeId(activeId);
            columns.add(column);
        }
        return columns;
    }

    private static List<Resource> getAncestors(Resource currentResource, Resource rootResource) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        if (currentResource == null || rootResource == null || StringUtils.equals((CharSequence)currentResource.getPath(), (CharSequence)rootResource.getPath())) {
            return results;
        }
        for (Resource parent = currentResource.getParent(); parent != null; parent = parent.getParent()) {
            results.add(0, parent);
            if (parent.getPath().equals(rootResource.getPath())) break;
        }
        return results;
    }
}

