/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.emulator.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.emulator.Emulator;
import com.day.cq.wcm.emulator.EmulatorGroup;
import com.day.cq.wcm.emulator.EmulatorProvider;
import com.day.cq.wcm.mobile.api.device.DeviceGroup;
import com.day.cq.wcm.mobile.api.device.DeviceGroupList;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EmulatorProvider.class}, property={"webconsole.configurationFactory.nameHint={templatePathPatterns}"})
@Designate(ocd=Config.class, factory=true)
public class EmulatorProviderImpl
implements EmulatorProvider {
    private List<Pattern> templatePathPatterns;
    private static final Logger log = LoggerFactory.getLogger(EmulatorProviderImpl.class);

    @Activate
    void activate(Config config) {
        this.templatePathPatterns = new ArrayList<Pattern>();
        for (String pattern : config.templatePathPatterns()) {
            try {
                this.templatePathPatterns.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException ex) {
                log.warn("Ignoring invalid template path pattern: {}", (Object)pattern, (Object)ex);
            }
        }
    }

    public boolean handles(Resource resource) {
        String templatePath;
        Page page = (Page)resource.adaptTo(Page.class);
        if (page != null && StringUtils.isNotEmpty((CharSequence)(templatePath = (String)page.getProperties().get("cq:template", String.class)))) {
            for (Pattern pattern : this.templatePathPatterns) {
                Matcher matcher = pattern.matcher(templatePath);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Emulator> getEmulators(Resource resource) {
        ArrayList<Emulator> emulators = new ArrayList<Emulator>();
        for (EmulatorGroup group : this.getEmulatorGroups(resource)) {
            emulators.addAll(group.getEmulators());
        }
        return emulators;
    }

    public List<EmulatorGroup> getEmulatorGroups(Resource resource) {
        DeviceGroupList deviceGroups;
        Page page = (Page)resource.adaptTo(Page.class);
        if (page != null && (deviceGroups = (DeviceGroupList)page.adaptTo(DeviceGroupList.class)) != null) {
            ArrayList<EmulatorGroup> emulatorGroups = new ArrayList<EmulatorGroup>();
            for (DeviceGroup deviceGroup : deviceGroups) {
                emulatorGroups.add(new EmulatorGroupImpl(deviceGroup));
            }
            return emulatorGroups;
        }
        return ImmutableList.of();
    }

    private static final class EmulatorGroupImpl
    implements EmulatorGroup {
        private final DeviceGroup deviceGroup;

        EmulatorGroupImpl(DeviceGroup deviceGroup) {
            this.deviceGroup = deviceGroup;
        }

        public String getTitle() {
            return this.deviceGroup.getTitle();
        }

        public String getDescription() {
            return this.deviceGroup.getDescription();
        }

        public String getPath() {
            return this.deviceGroup.getPath();
        }

        public String getName() {
            return this.deviceGroup.getName();
        }

        public List<Emulator> getEmulators() {
            return this.deviceGroup.getEmulators();
        }
    }

    @ObjectClassDefinition(name="wcm.io Emulator Provider", description="Provides emulators based on device groups in the pages with a configurable set of templates.")
    static @interface Config {
        @AttributeDefinition(name="Template Patterns", description="List of regular expressions to match template paths this emulator provider should apply to.")
        public String[] templatePathPatterns();
    }
}

