/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.pathfield.impl;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.PagingIterator;
import com.adobe.granite.ui.components.ds.AbstractDataSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.day.cq.commons.predicate.PredicateProvider;
import io.wcm.wcm.ui.granite.pathfield.impl.predicate.HideInternalContentPathsPredicate;
import io.wcm.wcm.ui.granite.pathfield.impl.util.DummyPageContext;
import io.wcm.wcm.ui.granite.pathfield.impl.util.PredicatedResourceWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"wcm-io/wcm/ui/granite/components/form/pathfield/datasources/children"})
public class PathFieldChildrenDatasourceServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String RESOURCE_TYPE = "wcm-io/wcm/ui/granite/components/form/pathfield/datasources/children";
    @Reference
    private ExpressionResolver expressionResolver;
    @Reference
    private PredicateProvider predicateProvider;
    private static final Logger log = LoggerFactory.getLogger(PathFieldChildrenDatasourceServlet.class);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Object ds;
        String searchName;
        String parentPath;
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, (PageContext)new DummyPageContext(request, response));
        Config cfg = new Config(request.getResource().getChild(Config.DATASOURCE));
        String query = ex.getString((String)cfg.get("query", String.class));
        if (query != null) {
            String rootPath = ex.getString((String)cfg.get("rootPath", (Object)"/"));
            int slashIndex = query.lastIndexOf(47);
            if (slashIndex < 0) {
                parentPath = rootPath;
                searchName = query.toLowerCase();
            } else if (!query.startsWith(rootPath)) {
                parentPath = rootPath;
                searchName = null;
            } else if (slashIndex == query.length() - 1) {
                parentPath = query;
                searchName = null;
            } else {
                parentPath = query.substring(0, slashIndex + 1);
                searchName = query.substring(slashIndex + 1).toLowerCase();
            }
        } else {
            parentPath = ex.getString((String)cfg.get("path", String.class));
            searchName = null;
        }
        final Resource parent = request.getResourceResolver().getResource(parentPath);
        if (parent == null) {
            ds = EmptyDataSource.instance();
        } else {
            final Integer offset = (Integer)ex.get((String)cfg.get("offset", String.class), Integer.class);
            final Integer limit = (Integer)ex.get((String)cfg.get("limit", String.class), Integer.class);
            String itemResourceType = (String)cfg.get("itemResourceType", String.class);
            String[] filter = new String[]{(String)ex.get((String)cfg.get("filter", (Object)"hierarchyNotFile"), String.class)};
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(new HideInternalContentPathsPredicate());
            predicates.addAll(this.toPredicates(filter));
            if (searchName != null) {
                final Pattern searchNamePattern = Pattern.compile(Pattern.quote(searchName), 2);
                predicates.add(new Predicate(){

                    public boolean evaluate(Object obj) {
                        Resource r = (Resource)obj;
                        return searchNamePattern.matcher(r.getName()).lookingAt();
                    }
                });
            }
            final Predicate predicate = PredicateUtils.allPredicate(predicates);
            final Transformer transformer = PathFieldChildrenDatasourceServlet.createTransformer(itemResourceType, predicate);
            AbstractDataSource datasource = new AbstractDataSource(){

                public Iterator<Resource> iterator() {
                    List list = IteratorUtils.toList((Iterator)new FilterIterator(parent.listChildren(), predicate));
                    if (!PathFieldChildrenDatasourceServlet.isOrderableChildNodes(parent)) {
                        Collections.sort(list, new Comparator<Resource>(){

                            @Override
                            public int compare(Resource r1, Resource r2) {
                                return r1.getName().compareTo(r2.getName());
                            }
                        });
                    }
                    return new TransformIterator((Iterator)new PagingIterator(list.iterator(), offset, limit), transformer);
                }
            };
            ds = datasource;
        }
        request.setAttribute(DataSource.class.getName(), ds);
    }

    private List<Predicate> toPredicates(@NotNull String[] filter) {
        if (filter == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(filter).stream().filter(Objects::nonNull).map(item -> {
            Predicate predicate = this.predicateProvider.getPredicate(item);
            if (predicate != null) {
                return predicate;
            }
            log.warn("Unable to find predicate implementation for filter: {}", item);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Transformer createTransformer(final String itemResourceType, final Predicate predicate) {
        return new Transformer(){

            public Resource transform(Object r) {
                return new PredicatedResourceWrapper((Resource)r, predicate){

                    public String getResourceType() {
                        if (itemResourceType == null) {
                            return super.getResourceType();
                        }
                        return itemResourceType;
                    }
                };
            }
        };
    }

    private static boolean isOrderableChildNodes(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.getPrimaryNodeType().hasOrderableChildNodes();
            }
            catch (RepositoryException ex) {
                return false;
            }
        }
        return false;
    }
}

