/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.pathfield.impl.predicate;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class HideInternalContentPathsPredicate
implements Predicate {
    private static final Set<String> HIDE_CONTENT_PATHS = ImmutableSet.builder().add((Object)"/content/catalogs").add((Object)"/content/cq:tags").add((Object)"/content/campaigns").add((Object)"/content/communities").add((Object)"/content/community").add((Object)"/content/community-components").add((Object)"/content/community-templates").add((Object)"/content/dam").add((Object)"/content/dam/catalogs").add((Object)"/content/dam/collections").add((Object)"/content/dam/formsanddocuments").add((Object)"/content/dam/formsanddocuments-themes").add((Object)"/content/dam/templates").add((Object)"/content/entities").add((Object)"/content/experience-fragments").add((Object)"/content/forms").add((Object)"/content/launches").add((Object)"/content/mac").add((Object)"/content/mobileapps").add((Object)"/content/publications").add((Object)"/content/usergenerated").add((Object)"/content/phonegap").add((Object)"/content/projects").add((Object)"/content/screens").add((Object)"/content/sites").add((Object)"/content/versionhistory").build();
    private static final Pattern FIRST_LEVEL_PATH = Pattern.compile("^/[^/]+$");
    private static final String CONTENT_ROOT_PATH = "/content";

    public boolean evaluate(Object object) {
        String path = ((Resource)object).getPath();
        if (FIRST_LEVEL_PATH.matcher(path).matches()) {
            return StringUtils.equals((CharSequence)path, (CharSequence)CONTENT_ROOT_PATH);
        }
        return !HIDE_CONTENT_PATHS.contains(path);
    }
}

