/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.resource;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class GraniteUiSyntheticResource
extends SyntheticResource {
    private final ValueMap props;
    private final Map<String, Resource> children;

    private GraniteUiSyntheticResource(ResourceResolver resourceResolver, ResourceMetadata resourceMetadata, String resourceType, ValueMap props, Iterable<Resource> children) {
        super(resourceResolver, resourceMetadata, resourceType);
        this.props = props;
        this.children = GraniteUiSyntheticResource.childrenMap(children);
    }

    private GraniteUiSyntheticResource(ResourceResolver resourceResolver, String path, String resourceType, ValueMap props, Iterable<Resource> children) {
        super(resourceResolver, path, resourceType);
        this.props = props;
        this.children = GraniteUiSyntheticResource.childrenMap(children);
    }

    private static Map<String, Resource> childrenMap(Iterable<Resource> children) {
        LinkedHashMap<String, Resource> result = new LinkedHashMap<String, Resource>();
        children.forEach(resource -> result.put(resource.getName(), (Resource)resource));
        return result;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (ValueMap.class.equals(type)) {
            return (Type)this.props;
        }
        return (Type)super.adaptTo(type);
    }

    public Iterator<Resource> listChildren() {
        return this.children.values().iterator();
    }

    public Iterable<Resource> getChildren() {
        return this.children.values();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Resource getChild(String relPath) {
        Resource child = this.children.get(relPath);
        if (child != null) {
            return child;
        }
        return super.getChild(relPath);
    }

    private void addChild(Resource child) {
        this.children.put(child.getName(), child);
    }

    public static Resource create(@NotNull ResourceResolver resourceResolver, @NotNull ValueMap valueMap) {
        return GraniteUiSyntheticResource.create(resourceResolver, null, "nt:unstructured", valueMap);
    }

    public static Resource create(@NotNull ResourceResolver resourceResolver, @Nullable String path, @NotNull String resourceType) {
        return GraniteUiSyntheticResource.create(resourceResolver, path, resourceType, ValueMap.EMPTY);
    }

    public static Resource create(@NotNull ResourceResolver resourceResolver, @Nullable String path, @NotNull String resourceType, @NotNull ValueMap valueMap) {
        return new GraniteUiSyntheticResource(resourceResolver, path, resourceType, valueMap, (Iterable<Resource>)ImmutableList.of());
    }

    public static Resource wrap(@NotNull Resource resource) {
        return GraniteUiSyntheticResource.wrap(resource, resource.getValueMap(), resource.getChildren());
    }

    public static Resource wrap(@NotNull Resource resource, @NotNull ValueMap valueMap) {
        return GraniteUiSyntheticResource.wrap(resource, valueMap, resource.getChildren());
    }

    public static Resource wrapMerge(@NotNull Resource resource, @NotNull ValueMap valueMap) {
        HashMap mergedProperties = new HashMap();
        mergedProperties.putAll(resource.getValueMap());
        mergedProperties.putAll(valueMap);
        return GraniteUiSyntheticResource.wrap(resource, (ValueMap)new ValueMapDecorator(mergedProperties), resource.getChildren());
    }

    private static Resource wrap(Resource resource, ValueMap valueMap, Iterable<Resource> children) {
        return new GraniteUiSyntheticResource(resource.getResourceResolver(), resource.getResourceMetadata(), resource.getResourceType(), valueMap, children);
    }

    public static Resource child(@NotNull Resource parentResource, @NotNull String name, @NotNull String resourceType) {
        return GraniteUiSyntheticResource.child(parentResource, name, resourceType, ValueMap.EMPTY);
    }

    public static Resource child(@NotNull Resource parentResource, @NotNull String name, @NotNull String resourceType, @NotNull ValueMap valueMap) {
        GraniteUiSyntheticResource child = new GraniteUiSyntheticResource(parentResource.getResourceResolver(), parentResource.getPath() + "/" + name, resourceType, valueMap, (Iterable<Resource>)ImmutableList.of());
        if (!(parentResource instanceof GraniteUiSyntheticResource)) {
            throw new IllegalArgumentException("Resource is not a GraniteUiSyntheticResource.");
        }
        ((GraniteUiSyntheticResource)parentResource).addChild((Resource)child);
        return child;
    }

    public static void copySubtree(@NotNull Resource targetParent, @NotNull Resource source) {
        Resource targetChild = GraniteUiSyntheticResource.child(targetParent, source.getName(), source.getResourceType(), source.getValueMap());
        for (Resource sourceChild : source.getChildren()) {
            GraniteUiSyntheticResource.copySubtree(targetChild, sourceChild);
        }
    }
}

