/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.ui.granite.pathfield.impl.predicate;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class HideInternalContentPathsPredicate
implements Predicate {
    private static final Set<String> HIDE_CONTENT_PATHS = Set.of("/content/catalogs", "/content/cq:tags", "/content/campaigns", "/content/communities", "/content/community", "/content/community-components", "/content/community-templates", "/content/dam", "/content/dam/catalogs", "/content/dam/collections", "/content/dam/formsanddocuments", "/content/dam/formsanddocuments-themes", "/content/dam/templates", "/content/entities", "/content/experience-fragments", "/content/forms", "/content/launches", "/content/mac", "/content/mobileapps", "/content/publications", "/content/usergenerated", "/content/phonegap", "/content/projects", "/content/screens", "/content/sites", "/content/versionhistory");
    private static final Pattern FIRST_LEVEL_PATH = Pattern.compile("^/[^/]+$");
    private static final String CONTENT_ROOT_PATH = "/content";

    public boolean evaluate(Object object) {
        String path = ((Resource)object).getPath();
        if (FIRST_LEVEL_PATH.matcher(path).matches()) {
            return StringUtils.equals((CharSequence)path, (CharSequence)CONTENT_ROOT_PATH);
        }
        return !HIDE_CONTENT_PATHS.contains(path);
    }
}

