/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.i18n;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

class SlingI18nMap {
    private static final String JCR_LANGUAGE = "language";
    private static final List<String> JCR_MIX_LANGUAGE = ImmutableList.of((Object)"mix:language");
    private static final String JCR_MIXIN_TYPES = "mixinTypes";
    private static final String JCR_NODETYPE_FOLDER = "nt:folder";
    private static final String JCR_PRIMARY_TYPE = "primaryType";
    private static final String SLING_KEY = "key";
    private static final String SLING_MESSAGE = "message";
    private static final List<String> SLING_MESSAGE_MIXIN_TYPE = ImmutableList.of((Object)"sling:Message");
    private static final Namespace NAMESPACE_SLING = Namespace.getNamespace((String)"sling", (String)"http://sling.apache.org/jcr/sling/1.0");
    private static final Namespace NAMESPACE_JCR = Namespace.getNamespace((String)"jcr", (String)"http://www.jcp.org/jcr/1.0");
    private static final Namespace NAMESPACE_MIX = Namespace.getNamespace((String)"mix", (String)"http://www.jcp.org/jcr/mix/1.0");
    private static final Namespace NAMESPACE_NT = Namespace.getNamespace((String)"nt", (String)"http://www.jcp.org/jcr/nt/1.0");
    private String languageKey;
    private final SortedMap<String, String> properties;

    SlingI18nMap(String languageKey, Map<String, String> properties) {
        this.languageKey = languageKey;
        this.properties = new TreeMap<String, String>(properties);
    }

    public String getI18nJsonString() throws JSONException {
        return this.buildI18nJson().toString(2);
    }

    private JSONObject buildI18nJson() throws JSONException {
        JSONObject jsonDocument = this.getMixLanguageJsonDocument();
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            String escapedKey;
            Map.Entry<String, String> entry;
            String key;
            JSONObject value = this.getJsonI18nValue(key, entry.getValue(), !StringUtils.equals((CharSequence)(key = (entry = iterator.next()).getKey()), (CharSequence)(escapedKey = SlingI18nMap.validName(key))));
            jsonDocument.put(escapedKey, (Object)value);
        }
        return jsonDocument;
    }

    private JSONObject getMixLanguageJsonDocument() throws JSONException {
        JSONObject root = new JSONObject();
        root.put("jcr:primaryType", (Object)JCR_NODETYPE_FOLDER);
        root.put("jcr:mixinTypes", JCR_MIX_LANGUAGE);
        root.put("jcr:language", (Object)this.languageKey);
        return root;
    }

    private JSONObject getJsonI18nValue(String key, String value, boolean generatedKeyProperty) throws JSONException {
        JSONObject valueNode = new JSONObject();
        valueNode.put("jcr:primaryType", (Object)JCR_NODETYPE_FOLDER);
        valueNode.put("jcr:mixinTypes", SLING_MESSAGE_MIXIN_TYPE);
        if (generatedKeyProperty) {
            valueNode.put("sling:key", (Object)key);
        }
        valueNode.put("sling:message", (Object)value);
        return valueNode;
    }

    public String getI18nXmlString() {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        return outputter.outputString(this.buildI18nXml());
    }

    private Document buildI18nXml() {
        Document xmlDocument = this.getMixLanguageXmlDocument();
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            String key;
            String escapedKey;
            Element value = this.getXmlI18nValue(escapedKey, key, entry.getValue(), !StringUtils.equals((CharSequence)(key = (entry = iterator.next()).getKey()), (CharSequence)(escapedKey = SlingI18nMap.validName(key))));
            xmlDocument.getRootElement().addContent((Content)value);
        }
        return xmlDocument;
    }

    private Document getMixLanguageXmlDocument() {
        Document doc = new Document();
        Element root = new Element("root", NAMESPACE_JCR);
        root.addNamespaceDeclaration(NAMESPACE_JCR);
        root.addNamespaceDeclaration(NAMESPACE_MIX);
        root.addNamespaceDeclaration(NAMESPACE_NT);
        root.addNamespaceDeclaration(NAMESPACE_SLING);
        doc.setRootElement(root);
        root.setAttribute(JCR_PRIMARY_TYPE, JCR_NODETYPE_FOLDER, NAMESPACE_JCR);
        root.setAttribute(JCR_MIXIN_TYPES, "[" + StringUtils.join(JCR_MIX_LANGUAGE, (String)",") + "]", NAMESPACE_JCR);
        root.setAttribute(JCR_LANGUAGE, this.languageKey, NAMESPACE_JCR);
        return doc;
    }

    private Element getXmlI18nValue(String escapedKey, String key, String value, boolean generatedKeyProperty) {
        Element valueNode = new Element(escapedKey);
        valueNode.setAttribute(JCR_PRIMARY_TYPE, JCR_NODETYPE_FOLDER, NAMESPACE_JCR);
        valueNode.setAttribute(JCR_MIXIN_TYPES, "[" + StringUtils.join(SLING_MESSAGE_MIXIN_TYPE, (String)",") + "]", NAMESPACE_JCR);
        if (generatedKeyProperty) {
            valueNode.setAttribute(SLING_KEY, key, NAMESPACE_SLING);
        }
        valueNode.setAttribute(SLING_MESSAGE, value, NAMESPACE_SLING);
        return valueNode;
    }

    private static String validName(String value) {
        String text = value;
        text = StringUtils.replace((String)text, (String)"\u00e4", (String)"ae");
        text = StringUtils.replace((String)text, (String)"\u00f6", (String)"oe");
        text = StringUtils.replace((String)text, (String)"\u00fc", (String)"ue");
        text = StringUtils.replace((String)text, (String)"\u00df", (String)"ss");
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.') continue;
            ch = '-';
            sb.setCharAt(i, ch);
        }
        return sb.toString();
    }

    public String getI18nPropertiesString() throws IOException {
        Properties i18nProps = new Properties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String escapedKey = SlingI18nMap.validName(key);
            i18nProps.put(escapedKey, entry.getValue());
        }
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            i18nProps.store(outStream, null);
            String string = outStream.toString("ISO-8859-1");
            return string;
        }
    }
}

