/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.i18n.readers;

import io.wcm.maven.plugins.i18n.readers.I18nReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class JsonI18nReader
implements I18nReader {
    @Override
    public Map<String, String> read(File sourceFile) throws IOException {
        String fileContent = IOUtils.toString((URL)sourceFile.toURI().toURL(), (String)"UTF-8");
        try {
            JSONObject root = new JSONObject(fileContent);
            HashMap<String, String> map = new HashMap<String, String>();
            this.parseJson(root, map, "");
            return map;
        }
        catch (JSONException ex) {
            throw new IOException("Unable to read JSON from " + sourceFile.getAbsolutePath(), ex);
        }
    }

    private void parseJson(JSONObject node, Map<String, String> map, String prefix) throws IOException, JSONException {
        JSONArray names = node.names();
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length(); ++i) {
            String key = names.getString(i);
            Object item = node.get(key);
            if (item instanceof JSONObject) {
                this.parseJson((JSONObject)item, map, prefix + key + ".");
                continue;
            }
            if (item instanceof String) {
                map.put(prefix + key, (String)item);
                continue;
            }
            throw new IOException("Unsupported JSON value: " + item.getClass().getName());
        }
    }
}

