/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.i18n.readers;

import io.wcm.maven.plugins.i18n.readers.I18nReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlI18nReader
implements I18nReader {
    @Override
    public Map<String, String> read(File sourceFile) throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
            builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
            Document doc = builder.build(sourceFile);
            HashMap<String, String> map = new HashMap<String, String>();
            this.parseXml(doc.getRootElement(), map, "");
            return map;
        }
        catch (JDOMException ex) {
            throw new IOException("Unable to read XML from " + sourceFile.getAbsolutePath(), ex);
        }
    }

    private void parseXml(Element node, Map<String, String> map, String prefix) {
        List children = node.getChildren();
        for (Element child : children) {
            String key = child.getName();
            if (!child.getChildren().isEmpty()) {
                this.parseXml(child, map, prefix + key + ".");
                continue;
            }
            map.put(prefix + key, child.getText());
        }
    }
}

