/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.installation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class TarUnArchiver {
    private final File archive;

    public TarUnArchiver(File archive) {
        this.archive = archive;
    }

    public void unarchive(String baseDir) throws MojoExecutionException {
        try (FileInputStream fis = new FileInputStream(this.archive);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)fis));){
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                File destPath = new File(baseDir + File.separator + tarEntry.getName());
                if (tarEntry.isSymbolicLink()) {
                    Path linkPath = destPath.toPath();
                    Path targetPath = new File(tarEntry.getLinkName()).toPath();
                    Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
                } else if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    destPath.createNewFile();
                    destPath.setExecutable(true);
                    try (BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));){
                        IOUtils.copy((InputStream)tarIn, (OutputStream)bout);
                    }
                }
                tarEntry = tarIn.getNextTarEntry();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not extract archive: " + this.archive.getAbsolutePath(), (Exception)ex);
        }
        this.archive.delete();
    }
}

