/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.installation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ZipUnArchiver {
    private final File archive;

    public ZipUnArchiver(File archive) {
        this.archive = archive;
    }

    public void unarchive(String baseDir) throws MojoExecutionException {
        try (FileInputStream fis = new FileInputStream(this.archive);
             ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)fis);){
            ZipArchiveEntry zipEnry = zipIn.getNextZipEntry();
            while (zipEnry != null) {
                File destPath = new File(baseDir + File.separator + zipEnry.getName());
                if (zipEnry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    destPath.createNewFile();
                    try (BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));){
                        IOUtils.copy((InputStream)zipIn, (OutputStream)bout);
                    }
                }
                zipEnry = zipIn.getNextZipEntry();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not extract archive: " + this.archive.getAbsolutePath(), (Exception)ex);
        }
        this.archive.delete();
    }
}

