/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.mojo.NodejsOutputStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Os;

public class Task {
    private static final String PATH_VARIABLE_NAME = "PATH";
    protected File workingDirectory;
    private Log log;

    public void execute(NodeInstallationInformation information) throws MojoExecutionException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.getCommand(information));
        if (this.workingDirectory != null) {
            if (!this.workingDirectory.exists()) {
                this.workingDirectory.mkdir();
            }
            processBuilder.directory(this.workingDirectory);
        } else if (this.isWorkingDirectoryMandatory()) {
            throw new MojoExecutionException("workingDirectory parameter missing for " + StringUtils.uncapitalize((String)this.getClass().getSimpleName()));
        }
        this.setNodePath(processBuilder, information);
        this.startProcess(processBuilder);
    }

    private void startProcess(ProcessBuilder processBuilder) throws MojoExecutionException {
        try {
            Process process = processBuilder.start();
            this.getLog().info((CharSequence)("Running process: " + StringUtils.join(processBuilder.command(), (String)" ")));
            this.initLogging(process);
            int result = process.waitFor();
            if (result != 0) {
                throw new MojoExecutionException("Process: " + StringUtils.join(processBuilder.command(), (String)" ") + " terminated with " + result);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error executing process: " + StringUtils.join(processBuilder.command(), (String)" "), (Exception)ex);
        }
        catch (InterruptedException ex) {
            throw new MojoExecutionException("Error executing process: " + StringUtils.join(processBuilder.command(), (String)" "), (Exception)ex);
        }
    }

    private void initLogging(Process process) throws InterruptedException {
        NodejsOutputStreamHandler infoLogThread = new NodejsOutputStreamHandler(process.getInputStream(), this.getLog());
        NodejsOutputStreamHandler errorLogThread = new NodejsOutputStreamHandler(process.getErrorStream(), this.getLog());
        infoLogThread.start();
        errorLogThread.start();
        infoLogThread.join();
        errorLogThread.join();
    }

    private void setNodePath(ProcessBuilder pbuilder, NodeInstallationInformation information) {
        Map<String, String> environment = pbuilder.environment();
        String pathVariableName = PATH_VARIABLE_NAME;
        String pathValue = environment.get(pathVariableName);
        if (Os.isFamily((String)"windows") || Os.isFamily((String)"win9x")) {
            for (String key : environment.keySet()) {
                if (!PATH_VARIABLE_NAME.equalsIgnoreCase(key)) continue;
                pathVariableName = key;
                pathValue = environment.get(key);
            }
        }
        if (pathValue == null) {
            environment.put(pathVariableName, information.getNodeExecutable().getParent());
        } else {
            environment.put(pathVariableName, information.getNodeExecutable().getParent() + File.pathSeparator + pathValue);
        }
    }

    protected List<String> getCommand(NodeInstallationInformation information) throws MojoExecutionException {
        return null;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected boolean isWorkingDirectoryMandatory() {
        return false;
    }
}

