/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.installation;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.installation.TarUnArchiver;
import io.wcm.maven.plugins.nodejs.installation.ZipUnArchiver;
import io.wcm.maven.plugins.nodejs.mojo.Task;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class NodeUnarchiveTask
extends Task {
    protected String nodeJsDirectory;

    public NodeUnarchiveTask(String nodeJsDirectory) {
        this.nodeJsDirectory = nodeJsDirectory;
    }

    @Override
    public void execute(NodeInstallationInformation information) throws MojoExecutionException {
        File archive = information.getArchive();
        if (StringUtils.endsWith((CharSequence)archive.getName(), (CharSequence)".zip")) {
            ZipUnArchiver unArchiver = new ZipUnArchiver(archive);
            unArchiver.unarchive(this.nodeJsDirectory);
        } else {
            TarUnArchiver unArchiver = new TarUnArchiver(archive);
            unArchiver.unarchive(this.nodeJsDirectory);
        }
    }
}

