/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.installation.NodeUnarchiveTask;
import io.wcm.maven.plugins.nodejs.mojo.NpmInstallTask;
import io.wcm.maven.plugins.nodejs.mojo.Task;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractNodeJsMojo
extends AbstractMojo {
    @Parameter(property="nodejs.version", defaultValue="10.15.3", required=true)
    protected String nodeJsVersion;
    @Parameter(property="nodejs.npm.version")
    protected String npmVersion;
    @Parameter(property="nodejs.directory", defaultValue="${java.io.tmpdir}/nodejs")
    protected File nodeJsDirectory;
    @Parameter
    protected List<? extends Task> tasks;
    @Parameter(defaultValue="true")
    protected boolean stopOnError;
    @Parameter(property="nodejs.skip")
    protected boolean skip;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;
    private static final ComparableVersion NODEJS_MIN_VERSION = new ComparableVersion("6.3.0");

    public void run() throws MojoExecutionException {
        ComparableVersion nodeJsVersionComparable;
        if (this.skip) {
            return;
        }
        if (this.tasks == null || this.tasks.isEmpty()) {
            this.getLog().warn((CharSequence)"No Node.js tasks have been defined. Nothing to do.");
        }
        if ((nodeJsVersionComparable = new ComparableVersion(this.nodeJsVersion)).compareTo(NODEJS_MIN_VERSION) < 0) {
            throw new MojoExecutionException("This plugin supports Node.js " + NODEJS_MIN_VERSION + " and up.");
        }
        NodeInstallationInformation information = this.getOrInstallNodeJS();
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                task.setLog(this.getLog());
                task.execute(information);
            }
        }
    }

    private NodeInstallationInformation getOrInstallNodeJS() throws MojoExecutionException {
        NodeInstallationInformation information;
        block7: {
            information = NodeInstallationInformation.forVersion(this.nodeJsVersion, this.npmVersion, this.nodeJsDirectory);
            try {
                if (!information.getNodeExecutable().exists() || !information.getNpmExecutableBundledWithNodeJs().exists()) {
                    this.getLog().info((CharSequence)("Install Node.js to " + information.getNodeJsInstallPath()));
                    if (!this.cleanNodeJsInstallPath(information)) {
                        throw new MojoExecutionException("Could not delete node js directory: " + information.getNodeJsInstallPath());
                    }
                    File nodeJsBinary = this.resolveArtifact(information.getNodeJsDependency());
                    FileUtils.copyFile((File)nodeJsBinary, (File)information.getArchive());
                    NodeUnarchiveTask installationTask = new NodeUnarchiveTask(this.nodeJsDirectory.getAbsolutePath());
                    installationTask.setLog(this.getLog());
                    ((Task)installationTask).execute(information);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.npmVersion) && !information.getNpmExecutable().exists()) {
                    this.updateNPMExecutable(information);
                }
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Malformed provided node URL", (Exception)ex);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Failed to get nodeJs from " + information.getNodeJsDependency()), (Throwable)ex);
                throw new MojoExecutionException("Failed to downloading nodeJs from " + information.getNodeJsDependency(), (Exception)ex);
            }
            catch (MojoExecutionException ex) {
                this.getLog().error((CharSequence)"Execution Exception", (Throwable)ex);
                if (!this.stopOnError) break block7;
                throw new MojoExecutionException("Execution Exception", (Exception)((Object)ex));
            }
        }
        return information;
    }

    private boolean cleanNodeJsInstallPath(NodeInstallationInformation information) {
        File directory = new File(information.getNodeJsInstallPath());
        if (directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException ex) {
                this.getLog().error((Throwable)ex);
                return false;
            }
        }
        return !information.getArchive().exists() || information.getArchive().delete();
    }

    private void updateNPMExecutable(NodeInstallationInformation information) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Installing specified npm version " + this.npmVersion));
        NpmInstallTask npmInstallTask = new NpmInstallTask();
        npmInstallTask.setLog(this.getLog());
        npmInstallTask.setNpmBundledWithNodeJs(true);
        npmInstallTask.setArguments(new String[]{"--prefix", information.getNpmPrefixPath(), "--global", "npm@" + this.npmVersion});
        npmInstallTask.execute(information);
    }

    private File resolveArtifact(Dependency dependency) throws MojoExecutionException {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), "provided", dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        try {
            this.resolver.resolve((Artifact)artifact, this.project.getRemoteArtifactRepositories(), this.session.getLocalRepository());
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoExecutionException("Unable to get artifact for " + dependency, (Exception)((Object)ex));
        }
        catch (ArtifactNotFoundException ex) {
            throw new MojoExecutionException("Unable to get artifact for " + dependency, (Exception)((Object)ex));
        }
        return artifact.getFile();
    }
}

