/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

final class NodejsOutputStreamHandler
extends Thread {
    private static final Pattern ERROR_LOG_PATTERN = Pattern.compile(".*(ERROR|FAILED|ERR|npm error).*");
    private static final Pattern WARNING_LOG_PATTERN = Pattern.compile(".*(warn).*", 2);
    private final InputStream inputStream;
    private final Log logger;

    NodejsOutputStreamHandler(InputStream inputStream, Log logger) {
        this.inputStream = inputStream;
        this.logger = logger;
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (ERROR_LOG_PATTERN.matcher(line = this.formatLine(line)).matches()) {
                    this.logger.error((CharSequence)line);
                    continue;
                }
                if (WARNING_LOG_PATTERN.matcher(line).matches()) {
                    this.logger.warn((CharSequence)line);
                    continue;
                }
                this.logger.info((CharSequence)line);
            }
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private String formatLine(String line) {
        String formatted = line.replaceAll("\u001b\\[[\\d;]*[^\\d;]", "");
        return "[nodejs] " + formatted;
    }
}

