/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.mojo.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NpmInstallTask
extends Task {
    private String[] arguments;
    private boolean npmBundledWithNodeJs;

    @Override
    protected List<String> getCommand(NodeInstallationInformation information) {
        ArrayList<String> commands = new ArrayList<String>();
        String nodeExecutable = information.getNodeExecutable().getAbsolutePath();
        String npmExecutable = this.npmBundledWithNodeJs ? information.getNpmExecutableBundledWithNodeJs().getAbsolutePath() : information.getNpmExecutable().getAbsolutePath();
        commands.add(nodeExecutable);
        commands.add(npmExecutable);
        commands.add("install");
        if (this.arguments != null && this.arguments.length > 0) {
            commands.addAll(Arrays.asList(this.arguments));
        }
        return commands;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isNpmBundledWithNodeJs() {
        return this.npmBundledWithNodeJs;
    }

    public void setNpmBundledWithNodeJs(boolean npmBundledWithNodeJs) {
        this.npmBundledWithNodeJs = npmBundledWithNodeJs;
    }
}

