/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import io.wcm.tooling.commons.contentpackagebuilder.NodeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class ContentFolderSplitter {
    private ContentFolderSplitter() {
    }

    public static List<ContentPart> split(Map<String, Object> content) {
        ArrayList<ContentPart> result = new ArrayList<ContentPart>();
        ContentFolderSplitter.collectRecursive("", content, result);
        return result;
    }

    private static void collectRecursive(String path, Map<String, Object> content, List<ContentPart> result) {
        HashMap<String, Object> resultContent = new HashMap<String, Object>();
        result.add(new ContentPart(path, resultContent));
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            Map childMap;
            if (entry.getValue() instanceof Map && NodeTypes.hasFolderNodeType(childMap = (Map)entry.getValue())) {
                ContentFolderSplitter.collectRecursive(path + "/" + entry.getKey(), childMap, result);
                continue;
            }
            resultContent.put(entry.getKey(), entry.getValue());
        }
    }

    static class ContentPart {
        private final String path;
        private final Map<String, Object> content;

        ContentPart(String path, Map<String, Object> content) {
            this.path = path;
            this.content = content;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, Object> getContent() {
            return this.content;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

