/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import io.wcm.tooling.commons.contentpackagebuilder.ContentElementConverter;
import io.wcm.tooling.commons.contentpackagebuilder.ContentFolderSplitter;
import io.wcm.tooling.commons.contentpackagebuilder.NameUtil;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilter;
import io.wcm.tooling.commons.contentpackagebuilder.PackageMetadata;
import io.wcm.tooling.commons.contentpackagebuilder.XmlContentBuilder;
import io.wcm.tooling.commons.contentpackagebuilder.element.ContentElement;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.w3c.dom.Document;

public final class ContentPackage
implements Closeable {
    private final PackageMetadata metadata;
    private final ZipOutputStream zip;
    private final Transformer transformer;
    private final XmlContentBuilder xmlContentBuilder;
    private static final String CONTENT_TYPE_CHARSET_EXTENSION = ";charset=";
    private static final String DOT_DIR_FOLDER = ".dir";

    ContentPackage(PackageMetadata metadata, OutputStream os) throws IOException {
        this.metadata = metadata;
        this.zip = new ZipOutputStream(os);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.transformer = transformerFactory.newTransformer();
            try {
                this.transformer.setOutputProperty("indent", "yes");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (TransformerException ex) {
            throw new RuntimeException("Failed to set up XML transformer: " + ex.getMessage(), ex);
        }
        this.xmlContentBuilder = new XmlContentBuilder(metadata.getXmlNamespaces());
        this.buildPackageMetadata();
    }

    public void addPage(String path, ContentElement content) throws IOException {
        String fullPath = ContentPackage.buildJcrPathForZip(path) + "/" + ".content.xml";
        Document doc = this.xmlContentBuilder.buildPage(content);
        this.writeXmlDocument(fullPath, doc);
    }

    public void addPage(String path, Map<String, Object> content) throws IOException {
        String fullPath = ContentPackage.buildJcrPathForZip(path) + "/" + ".content.xml";
        Document doc = this.xmlContentBuilder.buildPage(content);
        this.writeXmlDocument(fullPath, doc);
    }

    public void addContent(String path, ContentElement content) throws IOException {
        String basePath = ContentPackage.buildJcrPathForZip(path);
        List<ContentFolderSplitter.ContentPart> parts = ContentFolderSplitter.split(ContentElementConverter.toMap(content));
        for (ContentFolderSplitter.ContentPart part : parts) {
            String fullPath = basePath + part.getPath() + "/" + ".content.xml";
            Document doc = this.xmlContentBuilder.buildContent(part.getContent());
            this.writeXmlDocument(fullPath, doc);
        }
    }

    public void addContent(String path, Map<String, Object> content) throws IOException {
        String basePath = ContentPackage.buildJcrPathForZip(path);
        List<ContentFolderSplitter.ContentPart> parts = ContentFolderSplitter.split(content);
        for (ContentFolderSplitter.ContentPart part : parts) {
            String fullPath = basePath + part.getPath() + "/" + ".content.xml";
            Document doc = this.xmlContentBuilder.buildContent(part.getContent());
            this.writeXmlDocument(fullPath, doc);
        }
    }

    public void addContentForFile(String path, ContentElement content) throws IOException {
        this.addContent(path + DOT_DIR_FOLDER, content);
    }

    public void addContentForFile(String path, Map<String, Object> content) throws IOException {
        this.addContent(path + DOT_DIR_FOLDER, content);
    }

    public void addFile(String path, InputStream inputStream) throws IOException {
        this.addFile(path, inputStream, null);
    }

    public void addFile(String path, InputStream inputStream, String contentType) throws IOException {
        String fullPath = ContentPackage.buildJcrPathForZip(path);
        this.writeBinaryFile(fullPath, inputStream);
        if (StringUtils.isNotEmpty((CharSequence)contentType)) {
            String mimeType = StringUtils.substringBefore((String)contentType, (String)CONTENT_TYPE_CHARSET_EXTENSION);
            String encoding = StringUtils.substringAfter((String)contentType, (String)CONTENT_TYPE_CHARSET_EXTENSION);
            String fullPathMetadata = fullPath + DOT_DIR_FOLDER + "/" + ".content.xml";
            Document doc = this.xmlContentBuilder.buildNtFile(mimeType, encoding);
            this.writeXmlDocument(fullPathMetadata, doc);
        }
    }

    @VisibleForTesting
    static String buildJcrPathForZip(String path) {
        String normalizedPath = StringUtils.defaultString((String)path);
        if (!normalizedPath.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        NameUtil.ensureValidPath(path);
        return "jcr_root" + PlatformNameFormat.getPlatformPath((String)normalizedPath);
    }

    public void addFile(String path, File file) throws IOException {
        this.addFile(path, file, null);
    }

    public void addFile(String path, File file, String contentType) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            this.addFile(path, is, contentType);
        }
    }

    @Override
    public void close() throws IOException {
        this.zip.flush();
        this.zip.close();
    }

    public String getRootPath() {
        if (this.metadata.getFilters().size() == 1) {
            return this.metadata.getFilters().get(0).getRootPath();
        }
        throw new IllegalStateException("Content package has more than one package filter - please use getFilters().");
    }

    public List<PackageFilter> getFilters() {
        return this.metadata.getFilters();
    }

    private void buildPackageMetadata() throws IOException {
        this.metadata.validate();
        this.buildTemplatedMetadataFile("META-INF/vault/config.xml");
        this.buildPropertiesFile("META-INF/vault/properties.xml");
        this.buildTemplatedMetadataFile("META-INF/vault/settings.xml");
        this.buildTemplatedMetadataFile("META-INF/vault/definition/.content.xml");
        this.writeXmlDocument("META-INF/vault/filter.xml", this.xmlContentBuilder.buildFilter(this.metadata.getFilters()));
        byte[] thumbnailImage = this.metadata.getThumbnailImage();
        if (thumbnailImage != null) {
            this.zip.putNextEntry(new ZipEntry("META-INF/vault/definition/thumbnail.png"));
            try {
                this.zip.write(thumbnailImage);
            }
            finally {
                this.zip.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTemplatedMetadataFile(String path) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/content-package-template/" + path);){
            String xmlContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            for (Map.Entry<String, Object> entry : this.metadata.getVars().entrySet()) {
                xmlContent = StringUtils.replace((String)xmlContent, (String)("{{" + entry.getKey() + "}}"), (String)StringEscapeUtils.escapeXml10((String)entry.getValue().toString()));
            }
            this.zip.putNextEntry(new ZipEntry(path));
            try {
                this.zip.write(xmlContent.getBytes(Charsets.UTF_8));
            }
            finally {
                this.zip.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPropertiesFile(String path) throws IOException {
        Properties properties = new Properties();
        properties.put("requiresRoot", Boolean.toString(false));
        properties.put("allowIndexDefinitions", Boolean.toString(false));
        for (Map.Entry<String, Object> entry : this.metadata.getVars().entrySet()) {
            String value = Objects.toString(entry.getValue());
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            properties.put(entry.getKey(), value);
        }
        this.zip.putNextEntry(new ZipEntry(path));
        try {
            properties.storeToXML(this.zip, null);
        }
        finally {
            this.zip.closeEntry();
        }
    }

    private void writeXmlDocument(String path, Document doc) throws IOException {
        this.zip.putNextEntry(new ZipEntry(path));
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.zip);
            this.transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IOException("Failed to generate XML: " + ex.getMessage(), ex);
        }
        finally {
            this.zip.closeEntry();
        }
    }

    private void writeBinaryFile(String path, InputStream is) throws IOException {
        this.zip.putNextEntry(new ZipEntry(path));
        try {
            IOUtils.copy((InputStream)is, (OutputStream)this.zip);
        }
        finally {
            this.zip.closeEntry();
        }
    }
}

