/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import io.wcm.tooling.commons.contentpackagebuilder.AcHandling;
import io.wcm.tooling.commons.contentpackagebuilder.ContentPackage;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilter;
import io.wcm.tooling.commons.contentpackagebuilder.PackageMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public final class ContentPackageBuilder {
    private final PackageMetadata metadata = new PackageMetadata();

    public ContentPackageBuilder name(String value) {
        this.metadata.setName(value);
        return this;
    }

    public ContentPackageBuilder group(String value) {
        this.metadata.setGroup(value);
        return this;
    }

    public ContentPackageBuilder description(String value) {
        this.metadata.setDescription(value);
        return this;
    }

    public ContentPackageBuilder createdBy(String value) {
        this.metadata.setCreatedBy(value);
        return this;
    }

    public ContentPackageBuilder created(Date value) {
        this.metadata.setCreated(value);
        return this;
    }

    public ContentPackageBuilder version(String value) {
        this.metadata.setVersion(value);
        return this;
    }

    public ContentPackageBuilder acHandling(AcHandling value) {
        this.metadata.setAcHandling(value);
        return this;
    }

    public ContentPackageBuilder packageType(String value) {
        this.metadata.setPackageType(value);
        return this;
    }

    public ContentPackageBuilder requiresRoot(boolean value) {
        this.metadata.setRequiresRoot(value);
        return this;
    }

    public ContentPackageBuilder requiresRestart(boolean value) {
        this.metadata.setRequiresRestart(value);
        return this;
    }

    public ContentPackageBuilder allowIndexDefinitions(boolean value) {
        this.metadata.setAllowIndexDefinitions(value);
        return this;
    }

    public ContentPackageBuilder rootPath(String value) {
        this.metadata.addFilter(new PackageFilter(value));
        return this;
    }

    public ContentPackageBuilder filter(PackageFilter value) {
        this.metadata.addFilter(value);
        return this;
    }

    public ContentPackageBuilder property(String property, Object value) {
        this.metadata.addProperty(property, value);
        return this;
    }

    public ContentPackageBuilder xmlNamespace(String prefix, String uri) {
        this.metadata.addXmlNamespace(prefix, uri);
        return this;
    }

    public ContentPackageBuilder thumbnailImage(InputStream is) throws IOException {
        this.metadata.setThumbnailImage(IOUtils.toByteArray((InputStream)is));
        return this;
    }

    public ContentPackage build(OutputStream outputStream) throws IOException {
        return new ContentPackage(this.metadata, outputStream);
    }

    public ContentPackage build(File file) throws IOException {
        return this.build(new FileOutputStream(file));
    }
}

