/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

final class NameUtil {
    private static final String ILLEGAL_CHARS = "%/[]*|\t\r\n";
    private static final char NAMESPACE_SEPARATOR = ':';
    private static final Pattern ILLEGAL_CHARS_PATTERN;

    private NameUtil() {
    }

    public static boolean isValidName(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        int numberOfColons = StringUtils.countMatches((CharSequence)name, (char)':');
        if (numberOfColons > 1) {
            return false;
        }
        return !ILLEGAL_CHARS_PATTERN.matcher(name).find();
    }

    public static void ensureValidPath(String path) {
        String[] pathParts;
        String relativePath = StringUtils.startsWith((CharSequence)path, (CharSequence)"/") ? path.substring(1) : path;
        for (String pathPart : pathParts = StringUtils.split((String)relativePath, (String)"/")) {
            if (NameUtil.isValidName(pathPart)) continue;
            throw new IllegalArgumentException("Path contains illegal node names: " + path);
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < ILLEGAL_CHARS.length(); ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(Pattern.quote(ILLEGAL_CHARS.substring(i, i + 1)));
        }
        sb.append(")");
        ILLEGAL_CHARS_PATTERN = Pattern.compile(sb.toString());
    }
}

