/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import com.google.common.collect.ImmutableList;
import io.wcm.tooling.commons.contentpackagebuilder.NameUtil;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilterRule;
import java.util.ArrayList;
import java.util.List;

public final class PackageFilter {
    private final String rootPath;
    private final List<PackageFilterRule> rules = new ArrayList<PackageFilterRule>();

    public PackageFilter(String rootPath) {
        NameUtil.ensureValidPath(rootPath);
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public PackageFilter addIncludeRule(String pattern) {
        this.rules.add(new PackageFilterRule(pattern, true));
        return this;
    }

    public PackageFilter addExcludeRule(String pattern) {
        this.rules.add(new PackageFilterRule(pattern, false));
        return this;
    }

    public List<PackageFilterRule> getRules() {
        return ImmutableList.copyOf(this.rules);
    }
}

